/**********************************************************************************
 *
 * @file    .h
 * @brief   config.
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022-11-28      liuhy          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __ESSEMI_EXAMPLE_CONF_H__
#define __ESSEMI_EXAMPLE_CONF_H__

/* Includes ------------------------------------------------------------------ */
#include "es_gui_prj_conf.h"
#include "md_conf.h"
/* Exported Macros ----------------------------------------------------------- */

/* USER CODE BEGIN USER_CONFIG_0 */

#define ES_USE_MID_GUI    1

/*外部存储spi_flash设置*/
#define ES_GUI_PRJ_CONF_EXT_MEM_USE_SPIFLASH_FONT 2
#define ES_GUI_PRJ_CONF_EXT_MEM_USE_SPIFLASH_IMG  2

#define ES_GUI_USE_TOUCH 0
#define ES_GUI_USE_TOUCH_GT91X    0
#define ES_USE_ES_PDS_BOARD 0
#define ES_USE_ES_PDS_BOARD_VERSION    20200131


/*配置屏幕*/

/*屏幕xy轴是否交换*/
#define ES_LCD_DIR_X2Y       1

/*屏幕x轴是否翻转*/
#define ES_LCD_DIR_X_ORDER   1

/*屏幕y轴是否翻转*/
#define ES_LCD_DIR_Y_ORDER   0

#define ES_USE_LCD_AREA_OFFSET  1
#define ES_USE_LCD_AREA_OFFSET_X  {0)
#define ES_USE_LCD_AREA_OFFSET_Y  (80)

/*    屏幕像素: 240 * 320*/
#define ES_LCD_WIDTH   ES_GUI_PRJ_CONF_LCD_WIDTH
#define ES_LCD_LENGTH  ES_GUI_PRJ_CONF_LCD_LENGTH


/*配置LVGL*/
#define ES_LVGL_USE_2_DISP_BUF    0

#define ES_LVGL_EACH_COLOR_DISP_BUF_SIZE  (ES_LVGL_LCD_DISP_HOR_RES * 4)

#define ES_MCU_RAM_END_ADDR   0x20008000
#define ES_MCU_RAM_MIN_STACK_SIZE   0x1000
#define ES_RAM_STACK_HEAP_GAP_RAM_SIZE 0x200

#define ES_USE_USB_MSC_DEV_UPDATE_SPI_FLASH   1

/*部分底层接口*/
#define  ES_DELAY_MS(x)               es_delay_1ms((x))
#define  ES_DELAY_US(x)               md_delay_1us((x))

/* USER CODE END USER_CONFIG_0 */

/*    屏幕状态*/
#if ES_LCD_DIR_X2Y    /*屏幕xy轴是否交换 (1 << 5) */
    #define ES_LCD_X2Y_MASK             0x20
    #define ES_LCD_X2Y             ES_LCD_X2Y_MASK
#else
    #define ES_LCD_X2Y             0U
#endif /**/
#if ES_LCD_DIR_X_ORDER    /*屏幕x轴是否翻转 (1 << 6) */
    #define ES_LCD_X_ORDER_MASK         0x40
    #define ES_LCD_X_ORDER             ES_LCD_X_ORDER_MASK
#else
    #define ES_LCD_X_ORDER             0U
#endif /**/
#if ES_LCD_DIR_Y_ORDER    /*屏幕y轴是否翻转 (1 << 7) */
    #define ES_LCD_Y_ORDER_MASK         0x80
    #define ES_LCD_Y_ORDER             ES_LCD_Y_ORDER_MASK
#else
    #define ES_LCD_Y_ORDER             0U
#endif /**/

#if (ES_LCD_X2Y)
    #define ES_LVGL_LCD_DISP_HOR_RES   ES_LCD_LENGTH
    #define ES_LVGL_LCD_DISP_VER_RES   ES_LCD_WIDTH
#else
    #define ES_LVGL_LCD_DISP_HOR_RES   ES_LCD_WIDTH
    #define ES_LVGL_LCD_DISP_VER_RES   ES_LCD_LENGTH
#endif /*(ES_LCD_X2Y)*/

#if ES_GUI_USE_TOUCH

    #if ES_USE_ES_PDS_BOARD
        #undef ES_TOUCH_I2C_SDA_PIN_PORT
        #undef ES_TOUCH_I2C_SCL_PIN_PORT
        #undef ES_TOUCH_I2C_SDA_PIN_MD_FUNC
        #undef ES_TOUCH_I2C_SCL_PIN_MD_FUNC
        #undef ES_TOUCH_I2C_SDA_PIN_MD_PIN
        #undef ES_TOUCH_I2C_SCL_PIN_MD_PIN
    
        #define ES_TOUCH_I2C_SDA_PIN_PORT       (GPIOB)
        #define ES_TOUCH_I2C_SCL_PIN_PORT       (GPIOB)

        #if ES_USE_ES_PDS_BOARD_VERSION >= 20230506
            #define ES_TOUCH_I2C_SDA_PIN_MD_PIN     (MD_GPIO_PIN_11)
            #define ES_TOUCH_I2C_SCL_PIN_MD_PIN     (MD_GPIO_PIN_10)
        #else
            #define ES_TOUCH_I2C_SDA_PIN_MD_PIN     (MD_GPIO_PIN_10)
            #define ES_TOUCH_I2C_SCL_PIN_MD_PIN     (MD_GPIO_PIN_0)
        #endif /*ES_USE_ES_PDS_BOARD_VERSION >= 20230506*/
    #endif

#endif

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

/* USER CODE BEGIN USER_CONFIG_1 */

/* USER CODE END USER_CONFIG_1 */
    

void es_spi_datasize_8(SPI_I2S_TypeDef *SPIx);
void es_spi_datasize_16(SPI_I2S_TypeDef *SPIx);
void es_spi_fast(SPI_I2S_TypeDef *SPIx);
void es_spi_normal(SPI_I2S_TypeDef *SPIx);

void es_st7789_port_lcd_wrte_cmd(uint8_t cmd);
void es_st7789_port_lcd_wrte_data(uint8_t data);
void es_lvgl_init(void);
void es_lvgl_gt91x_touch_read(void);
uint8_t es_touch_gt911_read_data(uint16_t addr, uint8_t cnt, uint8_t *buf);
uint8_t es_touch_gt911_write_data(uint16_t addr, uint8_t value);
void ui_init(void);
void es_example_lv_time_callback1(void);
void es_mcu_init(void);
void es_gui_io_change_only_write_lcd(void);
void es_gui_io_change_only_read_write_flash(void);
void es_gui_io_change_read_flash_write_lcd(void);
void es_st7789_write_area_one_color(uint16_t x1, uint16_t x2, uint16_t y1, uint16_t y2,  uint16_t color);
void es_st7789_write_area_flash_spi_perh2perh(uint16_t x1, uint16_t x2, uint16_t y1, uint16_t y2,  uint32_t addr);
extern uint8_t es_push_stack_check(uint32_t size);

void es_delay_1ms(uint32_t ms);

void gui_main_init(void);
void gui_main_loop(void);

#endif /*__ESSEMI_EXAMPLE_CONF_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
