/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.29      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "md_utils.h"
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/****************** Peripheral Interrupt HANDLER ************************/
/**
  * @brief  CLINT irq handler
  * @retval None
  */
void __attribute__((interrupt)) CLINT_Handler(void)
{
    csi_coret_clr(md_cmu_get_clock() / 1000, CLINT_IRQn);
    md_inc_tick();
    lv_tick_inc(1);
    return;
}

/**
  * @brief  DMA IRQ handler
  * @retval None
  */
void __attribute__((interrupt)) DMA_Handler(void)
{
    uint32_t dma_transfer_num;

    if (md_dma_is_enabled_it_tc(MD_DMA_CH_0) && md_dma_is_active_flag_tc(MD_DMA_CH_0))
    {
        md_dma_clear_flag_tc(MD_DMA_CH_0);

        if (g_es_lvgl_lcd_tx_num == 0)
        {
            g_es_lvgl_lcd_tx_complete = 1;
#if (ES_LVGL_USE_2_DISP_BUF)

            if (g_es_dma_flush_disp_drv)
                lv_disp_flush_ready(g_es_dma_flush_disp_drv);

#endif /* (ES_LVGL_USE_2_DISP_BUF)*/
        }
        else
        {
            dma_transfer_num = (g_es_lvgl_lcd_tx_num > 65535) ? 65535 : g_es_lvgl_lcd_tx_num;
            md_dma_set_source_addr(MD_DMA_CH_0, g_es_lvgl_lcd_tx_buf);
            md_dma_set_transfer_size(MD_DMA_CH_0, dma_transfer_num);

            g_es_lvgl_lcd_tx_num -= dma_transfer_num;
            g_es_lvgl_lcd_tx_buf += dma_transfer_num;
            md_dma_enable_channel(MD_DMA_CH_0);
        }
    }

    return;
}

void __attribute__((interrupt)) ES_TOUCH_INT_IRQ_HANDLER(void)
{
    /* exti interrupt */
    if (md_gpio_is_enabled_external_interrupt(ES_TOUCH_INT_PIN_MD_PIN) && md_gpio_get_flag(ES_TOUCH_INT_PIN_MD_PIN))
    {
        md_gpio_clear_flag(ES_TOUCH_INT_PIN_MD_PIN);

        es_lvgl_gt91x_touch_read();
    }

    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
