/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "stdio.h"
#include "printf.h"
#include "ui.h"

/* Private Macros ------------------------------------------------------------ */
#define printf printf_/*Reduce ROM usage*/

/* Private Variables --------------------------------------------------------- */
static lv_disp_draw_buf_t s_draw_buf_dsc;
static lv_color_t s_draw_buf_1[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*A buffer for n rows*/
#if (ES_LVGL_USE_2_DISP_BUF)
    static lv_color_t s_draw_buf_2[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*An other buffer for n rows*/
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/
static lv_disp_drv_t s_es_disp_drv;                    /*Descriptor of a display driver*/
static lv_indev_drv_t s_indev_drv;
static lv_coord_t s_indev_x = 0;
static lv_coord_t s_indev_y = 0;
static lv_indev_state_t s_indev_state = LV_INDEV_STATE_RELEASED;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

#ifdef ES_LVGL_PORT_TOUCH_READ_MODIFY
/*目标圆弧:圆心*/
#define ES_O_CENTER_X   120
#define ES_O_CENTER_Y   160

/*目标圆弧:半径*/
#define ES_O_ARC_RADIUS   90

/*修改后的半径范围*/
#define ES_O_IN_RADIUS   40
#define ES_O_OUT_RADIUS   110

#define ES_SQRT_EPS 1
#define ES_ABS(x,y) (((x) > (y))?((x) - (y)):((y) - (x)))
#define ES_O_ARC_DISTANCE2   (ES_O_ARC_RADIUS * ES_O_ARC_RADIUS)
#define ES_O_IN_DISTANCE2   (ES_O_IN_RADIUS * ES_O_IN_RADIUS)
#define ES_O_OUT_DISTANCE2   (ES_O_OUT_RADIUS * ES_O_OUT_RADIUS)

int es_sqrt_low_precision(int n)
{
    int val = n;
    int last;

    do
    {
        last = val;
        val = (val + n / val) / 2;
    }
    while (ES_ABS(val, last) > ES_SQRT_EPS);

    return val;
}

#endif /*ES_LVGL_PORT_TOUCH_READ_MODIFY*/

static void touch_read(lv_indev_drv_t *s_indev_drv, lv_indev_data_t *data)
{
#ifdef ES_LVGL_PORT_TOUCH_READ_MODIFY
    int distance, distance2, cha_x, cha_y;
#endif /*ES_LVGL_PORT_TOUCH_READ_MODIFY*/

    data->state = s_indev_state;

#ifdef ES_LVGL_PORT_TOUCH_READ_MODIFY
    cha_x = s_indev_x - ES_O_CENTER_X;
    cha_y = s_indev_y - ES_O_CENTER_Y;
    distance2 = cha_x * cha_x + cha_y * cha_y;

    if ((distance2 <= ES_O_OUT_DISTANCE2) && (distance2 >= ES_O_IN_DISTANCE2))
    {
        distance = es_sqrt_low_precision(distance2);
        data->point.x = ES_O_CENTER_X + ((cha_x * ES_O_ARC_RADIUS) / distance);
        data->point.y = ES_O_CENTER_Y + ((cha_y * ES_O_ARC_RADIUS) / distance);
        return;
    }

#endif /*ES_LVGL_PORT_TOUCH_READ_MODIFY*/

    data->point.x = s_indev_x;
    data->point.y = s_indev_y;
}

void es_lvgl_gt91x_touch_read(void)
{
    uint8_t touch_state;
    struct es_touch_data touch_data;

    touch_state = gt911_touch_scan(&touch_data, 1);

    if (touch_state)
    {
        s_indev_state = LV_INDEV_STATE_PR;
        s_indev_x = touch_data.x_coordinate;
        s_indev_y = touch_data.y_coordinate;
    }
    else
    {
        s_indev_state = LV_INDEV_STATE_REL;
    }
}

void lv_port_disp_init(void)
{

#if (ES_LVGL_USE_2_DISP_BUF)
    lv_disp_draw_buf_init(&s_draw_buf_dsc, s_draw_buf_1, s_draw_buf_2, ES_LVGL_EACH_COLOR_DISP_BUF_SIZE);   /*Initialize the display buffer*/
#else
    lv_disp_draw_buf_init(&s_draw_buf_dsc, s_draw_buf_1, NULL, ES_LVGL_EACH_COLOR_DISP_BUF_SIZE);   /*Initialize the display buffer*/
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/

    lv_disp_drv_init(&s_es_disp_drv);                    /*Basic initialization*/

    /*Set the resolution of the display*/
    s_es_disp_drv.hor_res = ES_LVGL_LCD_DISP_HOR_RES;
    s_es_disp_drv.ver_res = ES_LVGL_LCD_DISP_VER_RES;

    /*Used to copy the buffer's content to the display*/
    s_es_disp_drv.flush_cb = es_lv_st7789_write_area;

    /*Set a display buffer*/
    s_es_disp_drv.draw_buf = &s_draw_buf_dsc;

    /*Finally register the driver*/
    lv_disp_drv_register(&s_es_disp_drv);
}

void lv_port_indev_init(void)
{
    lv_indev_drv_init(&s_indev_drv);
    s_indev_drv.type = LV_INDEV_TYPE_POINTER;
    s_indev_drv.read_cb = touch_read;
    lv_indev_drv_register(&s_indev_drv);
}

void es_lvgl_init(void)
{
#if LV_USE_LOG
#warning "need lv_log_register_print_cb()"
#endif /* LV_USE_LOG */
    lv_init();

    lv_port_disp_init();
    lv_port_indev_init();
}
