/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
#define GIF_INFO_OFFSET 2
#define IMAGE_INFO_OFFSET 9

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
uint8_t volatile g_touch_state = 0U;
uint8_t volatile g_xmod_update_flag = 0U;
uint8_t volatile g_image_next_flag = 0U;
uint16_t volatile g_image_interval_time = 0U;
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

extern void es_tst_st7789_write_area(uint16_t x1, uint16_t x2, uint16_t y1, uint16_t y2, uint16_t *color_p);

/* Private Function ---------------------------------------------------------- */

void _putchar(char character)
{
    while ((READ_BIT(CUART1->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK)
    {
    }

    md_uart_set_send_data8(CUART1, character);
}

void tst_lcd_all_color(uint16_t color)
{
    es_st7789_write_area_one_color(0, 239, 0, 319, color);
}

void show_spi_flash_img(uint32_t x1, uint32_t x2, uint32_t y1, uint32_t y2, uint32_t img_index, uint32_t img_offset_addr)
{
	es_st7789_write_area_flash_spi_perh2perh(x1, x2-1, y1, y2-1, (x2-x1)*(y2-y1)*2*img_index+img_offset_addr-1);
}

void touch_callback(void)
{
	uint8_t touch_state;
	struct es_touch_data touch_data;

	touch_state = gt911_touch_scan(&touch_data, 1);

	if (touch_state)
	{
		if (g_touch_state == 0)
			g_touch_state = 1;

		/*touch_data.x_coordinate*/;
		/*touch_data.y_coordinate*/;
	}
	else
	{
		if (g_touch_state == 1)
			g_touch_state = 2;

	}
}

void timer_callback(void)
{
	static uint16_t tick = 0;
	
	tick++;
	if(tick > g_image_interval_time)
	{
		g_image_next_flag = 1;
		tick = 0;
	}
}

int main(void)
{
	uint8_t buf[16], fps = 0;
	uint16_t x = 0, y = 0;
    uint32_t img_index = 0, gif_index = 0, gif_cnt = 0, gif_offset_addr = 0, bin_offset_addr = 0;
	GIF_UPDATE_STATUS_t update_gif_flag = GIF_INIT;

    /*初始化芯片*/
    es_mcu_init();

    printf("input \"update\" to update spi_flash data\r\n");

	usb_descriptor_init();

    gif_index = 0;
    img_index = 0;
    g_touch_state = 0;
    tst_lcd_all_color(0);

    md_gpio_set_pin_high(ES_LCD_BL_PIN_PORT, ES_LCD_BL_PIN_MD_PIN);
	update_gif_flag = 1;

    while (1)
    {
		USB->POWER |= (uint8_t)USB_POWER_SUSPENDEN_MSK;
		if((USB->POWER & 0x02))
		{
			if(update_gif_flag != GIF_RUN)
			{
				update_gif_flag = GIF_RUN;

				bin_offset_addr = bin_get_storage_addr_info();
				printf("bin_offset_addr = 0x%08X\r\n", bin_offset_addr);
				
				ll_flash_sector_read(&buf[0], bin_offset_addr, 11);
				gif_cnt = (buf[1]<<8)|buf[0];
				x = (buf[5]<<8)|buf[4];
				y = (buf[7]<<8)|buf[6];
				fps = buf[10];
				g_image_interval_time = 1000/fps;
				printf("gif count = %d\r\n", gif_cnt);
				printf("x:%d, y:%d, fps = %d, interval time = %d\r\n", x, y, fps, g_image_interval_time);
				
				gif_offset_addr = bin_offset_addr+GIF_INFO_OFFSET+IMAGE_INFO_OFFSET;
				gif_index = 0;
				g_image_next_flag = 1;
			}
			
			if(g_touch_state == 2)
			{
				g_touch_state = 0;
				gif_index = (gif_index+1)%gif_cnt;
				printf("next gif index = %d\r\n", gif_index);

				tst_lcd_all_color(0);
				if(gif_index == 0)
				{
					gif_offset_addr = bin_offset_addr+GIF_INFO_OFFSET+IMAGE_INFO_OFFSET;
				}
				else
				{
					gif_offset_addr = gif_offset_addr+(fps*x*y*2+IMAGE_INFO_OFFSET);
				}
				
				ll_flash_sector_read(&buf[0], gif_offset_addr-IMAGE_INFO_OFFSET, 9);
				x = (buf[3]<<8)|buf[2];
				y = (buf[5]<<8)|buf[4];
				fps = buf[8];
				g_image_interval_time = 1000/fps;
				printf("x:%d, y:%d, fps = %d, interval time = %d\r\n", x, y, fps, g_image_interval_time);
			}
			
			if(g_image_next_flag == 1)
			{
				g_image_next_flag = 0;
				show_spi_flash_img(0, x, 0, y, img_index, gif_offset_addr);
				img_index = (img_index + 1) % fps;
			}

			if (g_xmod_update_flag)
			{
				g_xmod_update_flag = 0;
				tst_lcd_all_color(0);
				update_spiflash();
				bin_set_storage_addr_info(0);
				update_gif_flag = GIF_UART_UPDATE;
			}
		}
		else 
		{
			tst_lcd_all_color(0);
			update_gif_flag = GIF_USB_UPDATE;
		}
    }
}