/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "ui.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint8_t volatile g_xmod_update_flag = 0U;
/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

void _putchar(char character)
{
    while ((READ_BIT(CUART1->STAT, UART_STAT_TFEMPTY_MSK)) != UART_STAT_TFEMPTY_MSK)
    {
    }

    md_uart_set_send_data8(CUART1, character);
}

void es_ui_obj_change(void)
{
    static uint32_t tick_ms_1 = 0U;
    static uint32_t tick_ms_2 = 0U;
    static uint32_t tick_ms_3 = 0U;
    char string[9];
    uint32_t value;
    const uint8_t speed_table[16] =
    {
        10U, 11U, 17U, 29U, 50U, 88U, 87U, 88U,
        86U, 85U, 67U, 68U, 69U, 70U, 74U, 75U,
    };

    if (lv_obj_has_flag(ui_Group_Battery, LV_OBJ_FLAG_HIDDEN))
    {
        if ((md_get_tick()) - tick_ms_1 >= 500)
        {
            tick_ms_1 = md_get_tick();

            value = ((tick_ms_1 % 39999) / 500);
            value = 80 - value;

            string[0] = '0' + (value / 10);
            string[1] = '0' + (value % 10);
            string[2] = '\0';

            lv_label_set_text(ui_Label_Battery_Number, string);
            lv_slider_set_value(ui_Slider_Battery, value, LV_ANIM_OFF);

            value = 80 - value;
            value = (value + 40) % 32;

            if (value >= 16)
                value = 31 - value;

            value = speed_table[value];

            string[0] = '0' + (value / 10);
            string[1] = '0' + (value % 10);
            string[2] = '\0';

            lv_label_set_text(ui_Speed_Number_1, string);
            lv_label_set_text(ui_Speed_Number_2, string);

            lv_slider_set_value(ui_Slider_Speed, value, LV_ANIM_OFF);

        }

        if ((md_get_tick()) - tick_ms_2 >= 500)
        {
            tick_ms_2 = md_get_tick();

            value = ((tick_ms_2 % 79999) / 500);

            string[0] = '0' + (value / 100);
            string[1] = '0' + ((value / 10) % 10);
            string[2] = '.';
            string[3] = '0' + (value % 10);
            string[4] = '\0';

            lv_label_set_text(ui_Label_Trip_Number, string);

            value = value + 2333;

            string[0] = '0' + (value / 1000);
            string[1] = '0' + ((value / 100) % 10);
            string[2] = '0' + ((value / 10) % 10);
            string[3] = '.';
            string[4] = '0' + (value % 10);
            string[5] = '\0';

            lv_label_set_text(ui_Label_ODO_Number, string);
        }

        if ((md_get_tick()) - tick_ms_3 >= 1000)
        {
            tick_ms_3 = md_get_tick();

            value = ((tick_ms_3 % 36000000) / 1000);

            string[0] = '0' + ((value / 3600) / 10);
            string[1] = '0' + ((value / 3600) % 10);
            string[2] = ':';
            string[3] = '0' + (((value / 60) % 60) / 10);
            string[4] = '0' + (((value / 60) % 60) % 10);
            string[5] = ':';
            string[6] = '0' + ((value % 60) / 10);
            string[7] = '0' + ((value % 60) % 10);
            string[8] = '\0';

            lv_label_set_text(ui_Label_Arrival_Time_Number1, string);

            value = 36000 - value;

            string[0] = '0' + ((value / 3600) / 10);
            string[1] = '0' + ((value / 3600) % 10);
            string[2] = ':';
            string[3] = '0' + (((value / 60) % 60) / 10);
            string[4] = '0' + (((value / 60) % 60) % 10);
            string[5] = ':';
            string[6] = '0' + ((value % 60) / 10);
            string[7] = '0' + ((value % 60) % 10);
            string[8] = '\0';

            lv_label_set_text(ui_Label_ETA_Number, string);
        }

    }
}

/**
  * @brief  main function
  * @retval Status.
  */
int main(void)
{
    /*初始化芯片*/
    es_mcu_init();

    printf("gui demo start\r\ninput \"update\" to update spi_flash data\r\n");

    /*初始化LVGL*/
    es_lvgl_init();

    /*SquareLine Studio 生成*/
    ui_init();

    lv_task_handler();
    md_gpio_set_pin_high(ES_LCD_BL_PIN_PORT, ES_LCD_BL_PIN_MD_PIN);

    while (1)
    {
        /* handle the tasks of LVGL */
        lv_task_handler();

        es_ui_obj_change();

        if (g_xmod_update_flag)
        {
            g_xmod_update_flag = 0;
            update_spiflash();
        }
    }
}
