import os
import sys
import re
import struct
import argparse
import subprocess
from datetime import datetime
import serial
from xmodem import XMODEM
from xmodem import XMODEM1k

ser = 0

def getc(size, timeout=1):
    global ser
    return ser.read(size) or None

def putc(data, timeout=1):
    global ser
    return ser.write(data)  # note that this ignores the timeout


def formatfiles():
    global ser

    print("串口配置")
    
    # 配置串口参数
    ser = serial.Serial(
        port='COM4',         # 串口号，例如在Windows上是'COM1'，在Linux上是'/dev/ttyUSB0'
        #baudrate=4500000,       # 波特率
        #baudrate=1500000,       # 波特率
        baudrate=921600,       # 波特率
        #baudrate=115200,       # 波特率
        #parity=serial.PARITY_EVEN,  # 校验位
        parity=serial.PARITY_NONE,  # 校验位
        stopbits=serial.STOPBITS_ONE,  # 停止位
        bytesize=serial.EIGHTBITS,  # 数据位
        timeout=1            # 读取超时设置，单位秒
    )
     
    # 检查串口是否成功打开
    if ser.isOpen():
        print("串口已打开")
    else:
        ser.open()
        if ser.isOpen():
            print("串口已打开")
        else:
            print("无法打开串口")
            return
    
    modem = XMODEM1k(getc, putc)
    
    for char in range(100):
        #print(chr(char))
        #ser.write(chr(char))
        ser.write(struct.pack('>B', 48))
        data = ser.read(1)
        
    data = ser.read(9999)
    data = ser.read(9999)
    data = ser.read(9999)

    #ser.write(b'\n\rupdate_data\n\r')
    
    for char in b'\n\r':
        ser.write(struct.pack('>B', char))
        data = ser.read(1)
        
    data = ser.read(9999)










    
    current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    print(current_time,"send update_data cmd")

    for char in b'update_data\n\r':
        ser.write(struct.pack('>B', char))
        data = ser.read(1)
        
    data = ser.read(9999)
    print("recv:",data)
    
    filename = 'es_gui_data.bin'
    stream = open(filename, 'rb')
    modem.send(stream)
    
    current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    print(current_time,"xmodem-1k transfer end")

    data = ser.read(9999)








    
    current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    print(current_time,"send update_app cmd")

    for char in b'update_app\n\r':
        #print(chr(char))
        #ser.write(chr(char))
        ser.write(struct.pack('>B', char))
        data = ser.read(1)
        
    data = ser.read(999)
    print("recv:",data)
    
    filename = 'app_crc.bin'
    stream = open(filename, 'rb')
    modem.send(stream)

    current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    print(current_time,"xmodem-1k transfer end")
    
    data = ser.read(9999)







    

    
    current_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    print(current_time,"send run_flash cmd")
    
    for char in b'run_flash\n\r':
        ser.write(struct.pack('>B', char))
        data = ser.read(1)
        
    data = ser.read(9999)






    
    
    ser.close()



if __name__ == '__main__':
    #print(ord('中'))
    formatfiles()
    #input('end')
