/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    9 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          9 Jan. 2023     Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __SPI_FLASH_H__
#define   __SPI_FLASH_H__

/* Includes ------------------------------------------------------------------ */
#include "md_gpio.h"
#include "md_spi.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */

#define FLASH_WRITE_ENABLE  0x06
#define FLASH_ERASE         0x20
#define FLASH_PROGRAM       0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05

#define FLASH_WRITE_ENABLE  0x06
#define FLASH_SEC_ERASE     0x20
#define FLASH_PAGE_PROGRAM  0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05
#define FLASH_ERASE_CHIP    0x60

/* flash information */
#define PAGE_SIZE           256
#define PAGE_PER_SEC        16

#define SEC_SIZE        4096
#define BLK_SIZE        16   /* 16 sectors */
#define DEV_SIZE        128  /* 128 blocks */
/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
uint32_t flash_read_id(void);
uint8_t ll_spi_flash_init(void);
uint8_t ll_flash_sector_read(uint8_t *str_buf, uint32_t sec, uint32_t sec_num);
uint8_t ll_flash_sector_write(const uint8_t *src_buf, uint32_t sec, uint32_t sec_num);
uint8_t ll_flash_chip_erase(void);
uint8_t ll_flash_erase_1sector_no_wait(uint32_t sec);
uint8_t ll_flash_sector_erase(uint32_t start_sec, uint32_t end_sec);
uint8_t flash_get_state_unbusy(void);
md_status_t flash_wait_unbusy(void);
void es_init_extern_flash(void);
uint8_t ll_flash_write(const uint8_t *buf, uint32_t addr, uint32_t size);
void spi_flash_init(void);

#endif    /*__FLASH_H__*/


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
