/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @version V1.0
 * @date    28 Feb 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          28 Feb 2023     AE Team         Bootloader for ES32VF2264
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include <string.h>
#include "md_conf.h"

/* Exported Macros ----------------------------------------------------------- */

/*
ES-PDS-ES32VF2264LT  , value = 1
ES-EVB-2264LQ-LCD-T1 , value = 0
*/
#define USE_BOARD_ES_PDS      1
#define USE_UART_RECV_BY_DMA  1

#if USE_BOARD_ES_PDS

    #define BOOT_UARTX  CUART1
    #define BOOT_UART_TX_PORT   GPIOA
    #define BOOT_UART_TX_PIN    MD_GPIO_PIN_2
    #define BOOT_UART_RX_PORT   GPIOA
    #define BOOT_UART_RX_PIN    MD_GPIO_PIN_3

#else

    #define BOOT_UARTX  CUART0
    #define BOOT_UART_TX_PORT   GPIOA
    #define BOOT_UART_TX_PIN    MD_GPIO_PIN_9
    #define BOOT_UART_RX_PORT   GPIOA
    #define BOOT_UART_RX_PIN    MD_GPIO_PIN_10

#endif/**/

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */


#endif /*__MAIN_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
