/**
  ********************************************************************************
  *
  * @file    boot_flash.h
  * @brief   Head file of boot flash module.
  *
  * @version V1.0
  * @date    28 Feb 2023
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          31 Dec 2019     AE Team         The first version
  *          28 Feb 2023     AE Team         Port to ES32VF2264
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef __BOOT_FLASH_H__
#define __BOOT_FLASH_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Includes ------------------------------------------------------------------ */

#include "boot.h"


/** @addtogroup Bootloader
  * @{
  */

/** @addtogroup Flash
  * @{
  */

/* Exported Macros ----------------------------------------------------------- */

/** @addtogroup Frame_Public_Macros Public Macros
  * @brief      Flash Public Macros
  * @{
  */
#ifdef BOOT_ES32VF2

#define BOOT_FLASH_S        0x0
#define BOOT_FLASH_E        0x8000
#define APP_FLASH_S         0x8000
#define APP_FLASH_E         0x3FFFF
#define APP_FLASH_INFO_S    0x3FFF8
#define APP_FLASH_INFO_E    0x3FFFF
#define APP_FLASH_SIZE      (APP_FLASH_E-APP_FLASH_S)
#define APP_FLASH_PAGE_SIZE 0x400
#define APP_RUN_RAM_S       0x20004000
#define APP_RUN_RAM_E       0x20018000
#define APP_LAST_PAGE       ((APP_FLASH_E-APP_FLASH_S)/APP_FLASH_PAGE_SIZE)

#define ADDR_CHECK_APP_FLASH_CRC_LEN                    (APP_FLASH_INFO_S+4)
#define ADDR_CHECK_APP_FLASH_CRC_START                  (APP_FLASH_S)
#endif /* BOOT_ES32VF2 */

#define INFO_ADDR_IN_PAGE (APP_FLASH_INFO_S&(APP_FLASH_PAGE_SIZE-1))
#define USR_FLASH_ADDER(x)  ((size_t)((x) * APP_FLASH_PAGE_SIZE + APP_FLASH_S))
#define VALID_APP_ADDR(a) ((a)>=APP_FLASH_S&&(a)<=APP_FLASH_E)

/* 启用CRC和长度校验 */
#define __USE_CRC32
/**
  * @}
  */

/* Exported Types ------------------------------------------------------------ */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/** @addtogroup Flash_Public_Functions
  * @{
  */
extern uint32_t flash_usr_page_get(void);
extern int flash_usr_page_erase(void);
extern int write_data_to_flash(uint16_t page, uint8_t *data, uint16_t crc);
/**
  * @}
  */
/**
  * @}
  */

/**
  * @}
  */
#ifdef __cplusplus
extern "C"
}
#endif /* __cplusplus */
#endif /* __BOOT_FLASH_H__ */
