/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "interrupt.h"

/* Private Macros ------------------------------------------------------------ */
#define UART_BUF_LEN (128)
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
uint8_t g_last_frame1 = 0;
uint8_t g_last_frame2 = 0;
uint8_t g_timer_int_as_tick = 0;
uint8_t g_last_sof_frame_change_tick = 0;
uint8_t g_usb_sof_frame_continue_change_times = 0;
volatile uint8_t g_usb_connect_flag = 0;

/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/**
  * @brief CLINT_Handler.
  * @note  systick handler.
  * @param none
  * @retval none
  */
void  __attribute__((interrupt)) CLINT_Handler(void)
{
    csi_coret_clr((md_cmu_get_sys_clock()) / 1000, 0);
    md_inc_tick();


    g_timer_int_as_tick++;

    {
        if ((USB->FRAME1 != g_last_frame1) || (USB->FRAME2 != g_last_frame2))
        {
            g_last_frame1 = USB->FRAME1;
            g_last_frame2 = USB->FRAME2;

            g_last_sof_frame_change_tick = g_timer_int_as_tick;

            if (g_usb_sof_frame_continue_change_times < 3)
            {
                g_usb_sof_frame_continue_change_times++;
            }
            else
            {
                g_usb_connect_flag = 1;
            }
        }
        else
        {
            if (g_timer_int_as_tick - g_last_sof_frame_change_tick > 3)
            {
                g_last_sof_frame_change_tick = g_timer_int_as_tick - 3;
                g_usb_sof_frame_continue_change_times = 0;
                g_usb_connect_flag = 0;
            }
        }
    }
}

/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
