/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"
#include "stdio.h"
#include "string.h"
#include "md_utils.h"
#include "md_cmu.h"
#include "md_rmu.h"
#include "md_gpio.h"
#include "md_uart.h"
#include "md_csu.h"

/* Exported Macros ----------------------------------------------------------- */

/*
ES-PDS-ES32VF2264LT  , value = 1
ES-EVB-2264LQ-LCD-T1 , value = 0
*/
#define USE_BOARD_ES_PDS  1

#if USE_BOARD_ES_PDS
#define BOOT_UART   CUART1
#else
#define BOOT_UART   CUART0
#endif

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
extern void cdc_acm_hid_winusb_descriptor_init(void);
extern void usb_dev_loop(void);
extern int usbd_read_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern int usbd_write_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern uint32_t es_pdf_test(char *input_fullpath);
extern void es_try_fatfs_unregister(void);
extern void es_fatfs_register(void);
extern void es_fatfs_error_handler(void);
extern void jump2app(void);

#endif /*__MAIN_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
