/**********************************************************************************
 *
 * @file    main.c
 * @brief   main file for global variable monitor sample project
 *
 * @version V1.0
 * @date    2021.07.05
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021.03.04      lvzd            the 1st version
 *          2021.07.05      biyq            the 2nd version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <math.h>
#include "main.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables -------------------------------------------------------- */

/* Public Variables --------------------------------------------------------- */
struct monitor_var_t
{
    int32_t     sin_value;
    int32_t     cos_value;
    float       f_sin_value;
    float       f_cos_value;
    int32_t     array[10];
} g_monitor_var;


/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function --------------------------------------------------------- */
int main(void)
{
    uint16_t i = 0U;
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);

    /* Enable ALL peripheral */
    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    MD_SYSCFG_LOCK();

    while (1)
    {
        g_monitor_var.sin_value = (int32_t)(1000 * sin((2 * 3.1415926 / 65535) * i)); /* sinx data */
        g_monitor_var.cos_value = (int32_t)(1000 * cos((2 * 3.1415926 / 65535) * i)); /* cosx data */

        g_monitor_var.f_sin_value = 1000 * sin((2 * 3.1415926 / 65535) * i) + 100; /* sinx data */
        g_monitor_var.f_cos_value = 1000 * cos((2 * 3.1415926 / 65535) * i) + 100; /* cosx data */

        g_monitor_var.array[1] = g_monitor_var.sin_value + 200;
        g_monitor_var.array[3] = g_monitor_var.cos_value + 200;

        i++;
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
