/**********************************************************************************
 *
 * @file    test_timer.c
 * @brief   test timer
 *
 * @date    17 Jan. 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          17 Jan. 2023    Shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef __TEST_TIMER_H__
#define __TEST_TIMER_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

/* Exported Macros ----------------------------------------------------------- */

/* Exported Types ------------------------------------------------------------ */
typedef struct {
	unsigned long long start, end;
	unsigned ticks_1us;
	
}test_timer_t;

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
static inline void start_timer(test_timer_t*timer)
{
    timer->ticks_1us = md_cmu_get_clock() / 1000000UL;
    timer->start = CORET->MTIME;
}
static inline void end_timer(test_timer_t*timer)
{
	timer->end = CORET->MTIME;
}
static inline uint32_t get_timer_us(test_timer_t*timer)
{
	return (timer->end-timer->start)/timer->ticks_1us;
}
#endif /* __TEST_TIMER_H__ */