ENTRY(__vector)
   __stack_end__ = 0x20000000  +  524288;
MEMORY {
  FLASH1  (rx) :  ORIGIN = 0x00000000 , LENGTH = 65536
  FLASH2  (rx) :  ORIGIN = 0x0 , LENGTH = 0
  RAM1  (wx) :   ORIGIN = 0x20000000 , LENGTH = 524288
  RAM2  (wx) :   ORIGIN = 0x0 , LENGTH = 0
  RAM3  (wx) :   ORIGIN = 0x0 , LENGTH = 0
}
SECTIONS {
 .text : 
 { 
	KEEP( *(.vectors));
*(EXCLUDE_FILE( *).text*)
    . = ALIGN(4);  
    KEEP(*(.init));
    KEEP(*(.fini));
    . = ALIGN(4);
    *(.rodata);
    . = ALIGN(4);
    *(.rodata*);
    . = ALIGN(4);
    *(.glue_7t);
    . = ALIGN(4);
    *(.glue_7);
    . = ALIGN(4);

    /* .ctors */
	*crtbegin.o(.ctors)
	*crtbegin?.o(.ctors)
	*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors)
	*(SORT(.ctors.*))
	*(.ctors)

	/* .dtors */
 	*crtbegin.o(.dtors)
 	*crtbegin?.o(.dtors)
 	*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors)
 	*(SORT(.dtors.*))
 	*(.dtors)
	*(.rodata*)
	KEEP(*(.eh_frame*))	
	 . = ALIGN(4);

 } > FLASH1

 .init_array :  
 { 
	
    PROVIDE_HIDDEN (__preinit_array_start = .);
	KEEP(*(.preinit_array*))
	PROVIDE_HIDDEN (__preinit_array_end = .);
	
	__init_array_start = .;
	KEEP(*(.init_array*))
	__init_array_end = .;
	. = ALIGN(4);

 } > FLASH1

 .ARM.extab :  
 { 
	
    *(.ARM.extab* .gnu.linkonce.armextab.*)
	. = ALIGN(4);

 } > FLASH1

 .ARM.exidx :  
 { 
	
    __exidx_start = .;
	*(.ARM.exidx* .gnu.linkonce.armexidx.*)
	__exidx_end = .;

 } > FLASH1

. = ALIGN(4);
_etext = . ;
 PROVIDE (etext = .);
_sidata = .;

_my_rom_end = _etext;

.ram1 : AT (_my_rom_end) 
 {
 
	. = ALIGN(4);
	_my_ram1_start = .;

 } > RAM1

_my_ram1_size = SIZEOF(.ram1);

.ram2 : AT (_my_rom_end + _my_ram1_size) 
 {
 
	. = ALIGN(4);
	_my_ram2_start = .;

 } > RAM1

_my_ram2_size = SIZEOF(.ram2);

.ram3 : AT (_my_rom_end + _my_ram1_size + _my_ram2_size) 
 {
 
	. = ALIGN(4);
	_my_ram3_start = .;

 } > RAM1

_my_ram3_size = SIZEOF(.ram3);

 .data : AT (_my_rom_end + _my_ram1_size + _my_ram2_size + _my_ram3_size) 
 { 
	
    __data_start__ = .;
	*(vtable)
	. = ALIGN(4);
	*(.data*)
	. = ALIGN(4);

	KEEP(*(.jcr*))
	. = ALIGN(4);
	/* All data end */
	__data_end__ = .;

 } > RAM1

. = ALIGN(4);
_edata = . ;
PROVIDE (edata = .);

 .bss : AT (_edata) 
 { 
	
    PROVIDE (__bss_start__ = .);
    *(.bss*)
    *(COMMON)
    . = ALIGN(4);
    PROVIDE (__bss_end__ = .);

    . = ALIGN(256);

 } > RAM1

_ram_current = ALIGN(4);

 .heap : AT (_ram_current) 
 { 
	
    PROVIDE (__heap_start = .);
    *(.heap*)
    PROVIDE (__heap_end__ = .);

 } > RAM1

_ram_current = ALIGN(4);

 .stack : AT (_ram_current) 
 { 
	
    PROVIDE (__stack_start = .);
    *(.stack)
    PROVIDE (__stack_end__ = .);

 } > RAM1

}
