/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"
#include "stdio.h"
#include "string.h"
#include "md_utils.h"
#include "md_cmu.h"
#include "md_rmu.h"
#include "md_gpio.h"
#include "md_uart.h"
#include "md_csu.h"
#include "md_dma.h"

/* Exported Macros ----------------------------------------------------------- */

/*
 * ES_TEST_USE_IRQ_TRANSFER = 1,use irq handle data.
 * ES_TEST_USE_IRQ_TRANSFER = 0,not use irq handle data.
 */
#define ES_TEST_USE_IRQ_TRANSFER 1

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
void cdc_acm_hid_winusb_descriptor_init(void);
void usb_dev_loop(void);
int usbd_read_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
int usbd_write_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
void cdc_uart_init(void);
uint16_t cdc_uartx_data_get(uint8_t uart_index, uint32_t *data_addr);
void cdc_uartx_data_update(uint8_t uart_index, uint16_t tx_len);
void cdc_uartx_send_over_check(void);
void cdc_uartx_send_start(uint8_t uart_index, uint16_t tx_len);
void cdc_uart_config(uint8_t uart_index);
void cdc_uart0_irq_handle(void);
void cdc_uart1_irq_handle(void);
void cdc_uart2_irq_handle(void);
void cdc_uart3_irq_handle(void);
void cdc_uart_handle(void);
void es_usbd_out_ep_recv(uint8_t cdc_index, uint32_t nbytes);

#endif /*__MAIN_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
