#ifndef __WM_I2S_H__
#define __WM_I2S_H__
/**********************************************************************************
 *
 * @file    wm_i2s.h
 * @brief   I2S driver for WM8978
 *
 * @date    31 Dec 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          31 Dec 2021     shiwa           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ----------------------------------------------------------------- */
#include <md_conf.h>
#include <stdint.h>

/* Exported Types ---------------------------------------------------------- */
typedef uint16_t (*func_I2S_callback)(void *, uint16_t);
struct wm_i2s_info
{
    /*buffer used for dma*/
    void *buffers[2];
    uint16_t buffer_length;
    /*SPIx used as I2S **TODO:use spi bus name instead of SPIx*/
    void *spi_x;
    /*callback to fill buffer(send) or get data(recv)*/
    func_I2S_callback feed_data;
    func_I2S_callback recv_data;
    /*DMA*/
    uint8_t dma_tx_ch;
    uint8_t dma_rx_ch;
    /*Audio info*/
    uint32_t sample_rate;
};

/* Exported Macros ----------------------------------------------------------- */
#define WM_RECV 0
#define WM_SEND 1
#define WM_SENDRECV 2
/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

/* I2S control */
int wm_i2s_init(struct wm_i2s_info *wm_info);
void wm_set_callback(uint32_t is_recv, func_I2S_callback f);
void wm_start(void);
void wm_record(void);
void wm_stop(void);
void wm_pause(void);
void wm_resume(void);
uint32_t wm_status(void);
int wm_set_sample_rate(uint32_t rate);

/* WM8978 control */
void wm_set_vol(uint32_t type, uint8_t vol);
void wm_set_mode(uint8_t mode);
#endif /*__WM_I2S_H__*/
