/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "interrupt.h"

/* Private Macros ------------------------------------------------------------ */
#define UART_BUF_LEN (128)
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/**
  * @brief CLINT_Handler.
  * @note  systick handler.
  * @param none
  * @retval none
  */
void  __attribute__((interrupt)) CLINT_Handler(void)
{
    csi_coret_clr((md_cmu_get_sys_clock()) / 1000, 0);
    md_inc_tick();
}

void __attribute__((interrupt)) CUART1_Handler(void)
{
    static char gUartBuf[UART_BUF_LEN];
    static int Idx = 0;
    static uint8_t EscFlag = 0;
    static char EscBuf[4];
    char Resieve;

    if (md_uart_mask_it_rfnempty(CUART1))
    {
        md_uart_clear_flag_rfnempty(CUART1);

        while (md_uart_is_active_flag_rfnempty(CUART1))
        {
            Resieve = CUART1->RXBUF;

            if (EscFlag)
            {
                EscBuf[EscFlag - 1] = Resieve;

                if (EscFlag == 2)
                {
                    EscBuf[2] = 0;
                    printf("\n\r");
                    Q_Sh_CmdHandler(1, EscBuf);
                    EscFlag = 0;
                }
                else
                {
                    EscFlag++;
                }
            }
            else
            {
                if (Resieve == 13)
                {
                    gUartBuf[Idx] = 0;
                    printf("\n\r");

                    if (Idx == 0)
                        printf("Shell>>");
                    else
                        Q_Sh_CmdHandler(0, gUartBuf);

                    Idx = 0;
                }
                else if (Resieve == 0x09)
                {
                    gUartBuf[4] = 0;
                    printf("\n\r");

                    gUartBuf[0] = 'l';
                    gUartBuf[1] = 'f';
                    gUartBuf[2] = '(';
                    gUartBuf[3] = ')';
                    Q_Sh_CmdHandler(0, gUartBuf);
                    Idx = 0;
                }
                else if (Resieve == 0x08)
                {
                    if (Idx > 0)
                    {
                        gUartBuf[--Idx] = 0;
                        printf("\b \b");
                    }
                }
                else if (Resieve >= 0x20)
                {
                    gUartBuf[Idx++] = Resieve;
                    printf("%c", Resieve);
                }
                else if (Resieve == 0x1B)
                {
                    EscFlag = 1;
                }
                else
                {
                }

                if (Idx >= UART_BUF_LEN)
                    Idx--;
            }
        }

    }

    return;
}
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
