/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "interrupt.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

/**
  * @brief CLINT_Handler.
  * @note  systick handler.
  * @param none
  * @retval none
  */
void  __attribute__((interrupt)) CLINT_Handler(void)
{
    csi_coret_clr((md_cmu_get_sys_clock()) / 1000, 0);
    md_inc_tick();
}


#if defined(ES_USBD_CDC_USE_UART)

    uint8_t usb_cdc_uart_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];
    uint8_t usb_cdc_data_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];

    uint32_t rxcount_from_uart = 0U;
    uint32_t txcount_to_uart = 0U;
    uint32_t rxcount_from_usb = 0U;
    uint32_t txcount_to_usb = 0U;
#endif /*defined(ES_USBD_CDC_USE_UART)*/

#if defined(ES_USBD_CDC_USE_UART)

void __attribute__((interrupt)) CUART2_Handler(void)
{
    ald_usb_int_unregister();

    if (md_uart_mask_it_tfempty(CUART2))
    {
        if (rxcount_from_usb != txcount_to_uart)
        {
            md_uart_set_send_data8(CUART2, usb_cdc_data_rxbuf[ES_GET_USBD_CDC_UART_BUF_GET_INDEX(txcount_to_uart)]);
            txcount_to_uart++;
        }
        else
        {
            md_uart_disable_it_tfempty(CUART2);
        }

        md_uart_clear_it_tfempty(CUART2);
    }

    if (md_uart_mask_it_rfnempty(CUART2))
    {
        usb_cdc_uart_rxbuf[ES_GET_USBD_CDC_UART_BUF_GET_INDEX(rxcount_from_uart)] = md_uart_recv_data8(CUART2);
        rxcount_from_uart++;

        md_uart_clear_flag_rfnempty(CUART2);
    }

    ald_usb_int_register();

    return;
}

#endif /*defined(ES_USBD_CDC_USE_UART)*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
