/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"
#include "stdio.h"
#include "string.h"
#include "md_utils.h"
#include "md_cmu.h"
#include "md_rmu.h"
#include "md_gpio.h"
#include "md_uart.h"
#include "md_csu.h"

/* Exported Macros ----------------------------------------------------------- */
#if defined(ES_USBD_CDC_USE_UART)

    #define ES_USBD_CDC_UART_BUF_SIZE       (2048)

    #if ES_USBD_CDC_UART_BUF_SIZE == 2048
        #define ES_GET_USBD_CDC_UART_BUF_GET_INDEX(x)       ((x) & 0x7FF)
    #else
        #define ES_GET_USBD_CDC_UART_BUF_GET_INDEX(x)       ((x) % (ES_USBD_CDC_UART_BUF_SIZE))
    #endif/*ES_USBD_CDC_UART_BUF_SIZE == 2048*/

    extern uint8_t usb_cdc_uart_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];
    extern uint8_t usb_cdc_data_rxbuf[ES_USBD_CDC_UART_BUF_SIZE];

    extern uint32_t rxcount_from_uart;
    extern uint32_t txcount_to_uart;
    extern uint32_t rxcount_from_usb;
    extern uint32_t txcount_to_usb;
#endif /*defined(ES_USBD_CDC_USE_UART)*/

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
extern void cdc_acm_hid_winusb_descriptor_init(void);
extern void usb_dev_loop(void);
extern int usbd_read_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern int usbd_write_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);

#endif /*__MAIN_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
