/**
  *********************************************************************************
  *
  * @file    boot_fatfs.c
  * @brief   Fatfs file for DEMO
  *
  * @version V1.0
  * @date    31 Dec 2019
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          31 Dec 2019     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

/* Includes-------------------------------------------------------------------*/
#include "boot_fatfs.h"

/** @addtogroup Bootloader Bootloader
  * @{
  */
/** @defgroup USB_Fatfs Fatfs
  * @brief    USB Fatfs Module
  * @{
  */

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

/** @defgroup Fatfs_Public_Variables Public Variables
  * @brief    Fatfs Public Variables
  * @{
  */
fat_type_e_t g_es_fatfs_type = TYPE_UKNOW;
const uint8_t g_es_fatfs_bs_jmpboot[3] = {0xEB, 0x3C, 0x90};
const uint8_t g_es_fatfs_bs_oemname[8] = {0x4D, 0x53, 0x44, 0x4F, 0x53, 0x35, 0x2E, 0x30};
const uint8_t g_es_fatfs_bpb_bytepersec[2] = {DISK_BLOCK_SIZE & 0xFF, DISK_BLOCK_SIZE >> 8};
const uint8_t g_es_fatfs_bpb_secperclus[1] = {DISK_CLUS_N_SECTORS};
const uint8_t g_es_fatfs_bpb_rsvseccnt[2] = {0x01, 0x00};
const uint8_t g_es_fatfs_bpb_numfats[1] = {0x02};
const uint8_t g_es_fatfs_bpb_rootentcnt[2] = {0x40, 0x00};/*{0x00, 0x02};*/
const uint8_t g_es_fatfs_bpb_totsec16[2] = {DISK_BLOCK_NR & 0xFF, DISK_BLOCK_NR >> 8};
const uint8_t g_es_fatfs_bpb_media[1] = {0xF8};
const uint8_t g_es_fatfs_bpb_fatsz16[2] = {0x01, 0x00};
const uint8_t g_es_fatfs_bpb_secpertrk[2] = {0x01, 0x00};
const uint8_t g_es_fatfs_bpb_numheads[2] = {0x00, 0x00};
const uint8_t g_es_fatfs_bpb_hiddsec[4] = {0x00, 0x00, 0x00, 0x00};
const uint8_t g_es_fatfs_bpb_totsec32[4] = {0x00, 0x00, 0x00, 0x00};
const uint8_t g_es_fatfs_bs_drcnum[1] = {0x80};
const uint8_t g_es_fatfs_bs_reserved1[1] = {0x00};
const uint8_t g_es_fatfs_bs_bootsig[1] = {0x29};
const uint8_t g_es_fatfs_bs_volid[4] = {0x1C, 0x6B, 0x44, 0xBA};
const uint8_t g_es_fatfs_bs_vollab[11] = {0x4E, 0x4F, 0x20, 0x4E, 0x41, 0x4D, 0x45, 0x20, 0x20, 0x20, 0x20};
const uint8_t g_es_fatfs_bs_filsystype[8] = {0x46, 0x41, 0x54, 0x31, 0x32, 0x20, 0x20};
const uint8_t g_es_fatfs_singature[2] = {0x55, 0xAA};
const uint8_t g_es_fatfs_fat[3] = {0xF8, 0xFF, 0xFF};
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @defgroup Fatfs_Private_Functions Private Functions
  * @brief    Fatfs Private Functions
  * @{
  */

/**
  * @brief  initialize fs BDR.
  * @param  buf: BDR section
  * @retval None.
  */
static void init_fat12_bdr(uint8_t *buf)
{
    if (buf == NULL)
        return ;

    memcpy(&buf[0], g_es_fatfs_bs_jmpboot, 3);
    memcpy(&buf[3], g_es_fatfs_bs_oemname, 8);
    memcpy(&buf[11], g_es_fatfs_bpb_bytepersec, 2);
    memcpy(&buf[13], g_es_fatfs_bpb_secperclus, 1);
    memcpy(&buf[14], g_es_fatfs_bpb_rsvseccnt, 2);
    memcpy(&buf[16], g_es_fatfs_bpb_numfats, 1);
    memcpy(&buf[17], g_es_fatfs_bpb_rootentcnt, 2);
    memcpy(&buf[19], g_es_fatfs_bpb_totsec16, 2);
    memcpy(&buf[21], g_es_fatfs_bpb_media, 1);
    memcpy(&buf[22], g_es_fatfs_bpb_fatsz16, 2);
    memcpy(&buf[24], g_es_fatfs_bpb_secpertrk, 2);
    memcpy(&buf[26], g_es_fatfs_bpb_numheads, 2);
    memcpy(&buf[28], g_es_fatfs_bpb_hiddsec, 4);
    memcpy(&buf[32], g_es_fatfs_bpb_totsec32, 4);
    memcpy(&buf[36], g_es_fatfs_bs_drcnum, 1);
    memcpy(&buf[37], g_es_fatfs_bs_reserved1, 1);
    memcpy(&buf[38], g_es_fatfs_bs_bootsig, 1);
    memcpy(&buf[39], g_es_fatfs_bs_volid, 4);
    memcpy(&buf[43], g_es_fatfs_bs_vollab, 11);
    memcpy(&buf[54], g_es_fatfs_bs_filsystype, 8);
    memcpy(&buf[510], g_es_fatfs_singature, 2);
}

/**
  * @brief  initialize fs FAT.
  * @param  buf: FAT section
  * @retval None.
  */
static void init_fat12_fat(uint8_t *buf)
{
    if (buf == NULL)
        return ;

    memcpy(&buf[0], g_es_fatfs_fat, 3);

    return ;
}

/**
  * @brief  initialize a FAT12 fs.
  * @retval None.
  */
void init_fat12_fs(void)
{
    memset(g_tmp_buf_page, 0, sizeof(g_tmp_buf_page));
    init_fat12_bdr(g_tmp_buf_page);

    fs_flash_write(g_tmp_buf_page, 0, 1);

    memset(g_tmp_buf_page, 0, sizeof(g_tmp_buf_page));
    init_fat12_fat(g_tmp_buf_page);
    fs_flash_write(g_tmp_buf_page, 1, 1);
    fs_flash_write(g_tmp_buf_page, 2, 1);
}

/**
  * @}
  */
/**
  * @}
  */
