/**********************************************************************************
 *
 * @file    .c
 * @brief   Source file
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes-------------------------------------------------------------------*/
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
#define __USE_CRC32
#define ___AUTO_JUMP2APP  1
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */

void usb_dc_low_level_init(void)
{

}

/**
  * @brief user_system_config system configuration.
  * @param none
  * @retval none
  */
static void user_system_config(void)
{
    md_cmu_pll_config(MD_CMU_PLL_INPUT_HOSC8M, MD_CMU_PLL_OUTPUT_72M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL, 72000000);

    MD_SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    md_cmu_enable_usbck48();/*USB 48M使能*/
    md_csu_enable_auto();
    md_csu_enable_cnt();
    MD_SYSCFG_LOCK();
    md_rmu_reset_periperal(MD_RMU_PERH_USB);
    md_init_1ms_tick();
    __enable_irq();

    return;
}

uint8_t check_app_crc(void)
{
#ifdef __USE_CRC32
    uint32_t i;
    md_crc_init_t g_crc_init;

    if (*((uint32_t *)(ADDR_CHECK_APP_FLASH_CRC_LEN)) != 0x37FF0U)
        return 1;

    /* Init CRC */
    md_crc_init_struct(&g_crc_init);
    g_crc_init.mode = MD_CRC_MODE_32;
    g_crc_init.len = MD_CRC_DATASIZE_32;
    g_crc_init.order = MD_CRC_BYTORD_LOW;
    g_crc_init.seed = 0xFFFFFFFF;
    g_crc_init.chs_inv = ENABLE;
    g_crc_init.chs_rev = ENABLE;
    g_crc_init.data_inv = DISABLE;
    g_crc_init.data_rev = ENABLE;
    md_crc_init(&g_crc_init);

    for (i = APP_FLASH_START_ADDRESS; i < ADDR_CHECK_APP_FLASH_CRC_ADDR ; i += 4)
    {
        md_crc_write_data(CRC, *((uint32_t *)(i)));
    }

    if ((*((uint32_t *)(ADDR_CHECK_APP_FLASH_CRC_ADDR)) != md_crc_get_check_result(CRC)))
        return 1;

#endif/*__USE_CRC32*/

    return 0;
}

/**
  * @brief main.
  * @param none
  * @retval none
  */
int main(void)
{
    uint32_t last_busy_tick = 0U;

    user_system_config();

    md_delay_1us(20);

#if ___AUTO_JUMP2APP

    if (!(check_app_crc()))
        application_check_and_run();

#endif/*___AUTO_JUMP2APP*/

    cdc_acm_hid_winusb_descriptor_init();

    while (1)
    {
        usb_dev_loop();

        if (g_hid_boot_ep_flag == 0U)
        {
            if (g_boot_complete && ((md_get_tick() - last_busy_tick) > 1000))
            {
                g_boot_complete = 0;

                if (!(check_app_crc()))
                    application_check_and_run();
            }
        }
        else
        {
            last_busy_tick = md_get_tick();
        }
    }
}

/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF FILE ****/
