/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"
#include "stdio.h"
#include "string.h"
#include "md_utils.h"
#include "md_cmu.h"
#include "md_rmu.h"
#include "md_gpio.h"
#include "md_uart.h"
#include "md_crc.h"
#include "md_csu.h"

/* Exported Macros ----------------------------------------------------------- */
#define APP_FLASH_START_ADDRESS             (0x000008000U)
#define APP_FLASH_SIZE                      (0x000038000U)

#define ADDR_CHECK_APP_FLASH_CRC_LEN                    (0x00003FFF4U)
#define ADDR_CHECK_APP_FLASH_CRC_ADDR                   (0x00003FFF0U)

#define LED_PORT GPIOC
#define LED_PIN  MD_GPIO_PIN_12
/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern volatile uint8_t g_configed_flag;
extern uint8_t g_jump2boot_flag;
extern uint8_t g_hid_boot_ep_flag;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
extern void cdc_acm_hid_winusb_descriptor_init(void);
extern void usb_dev_loop(void);
extern int usbd_read_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern int usbd_write_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern uint8_t application_check_and_run(void);
extern uint32_t es_lab_commands_process(uint8_t *request, uint8_t *response);
extern uint8_t app_flash_erase_area(uint32_t addr, uint32_t size);

#endif /*__MAIN_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
