/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"
#include "stdio.h"
#include "string.h"
#include "md_utils.h"
#include "md_cmu.h"
#include "md_rmu.h"
#include "md_gpio.h"
#include "md_uart.h"
#include "md_csu.h"
#include "boot_conf.h"
#include "es_hid_lab.h"
#include "app_update.h"
#include "usb_config.h"

/* Exported Macros ----------------------------------------------------------- */
/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern volatile uint8_t g_configed_flag;
extern uint32_t g_boot_complete;
extern uint32_t g_hid_boot_ep_transfer_time;
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
extern void cdc_acm_hid_winusb_descriptor_init(void);
extern void jump2boot(void);
extern int usbd_write_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);

#endif /*__MAIN_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
