/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-03-08         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#ifndef   __USB_MSC_BOOT_H__
#define   __USB_MSC_BOOT_H__

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus*/

/* Includes ------------------------------------------------------------------ */
/* Exported Macros ----------------------------------------------------------- */

/*BOOT 程序区*/
#define BOOT_FLASH_S            (0x000000)
#define BOOT_FLASH_E            (0x001FFF)
#define APP_FLASH_S             (0x002000)

/*更新标志 + 信息区域。区域大小 = 1页FLASH大小*/
#define INFO_FLAG_FLASH_S       (0x03FE00)
#define INFO_FLAG_FLASH_E       (0x03FFFF)

/*更新信息地址*/
#define UPDATE_INFO_CRC_LEN             (0x03FE00)
#define UPDATE_INFO_CRC_VALUE           (0x03FE04)
#define UPDATE_INFO_NEW_APP_ADDR        (0x03FE08)

#define MSC_DEV_NEW_APP_ADDR         (0x020000)
#define NORMAL_NEW_APP_ADDR          (0x021000)

#define FAT_AND_NEW_APP_FLASH_S      (0x020000)
#define FAT_AND_NEW_APP_FLASH_E      (0x03FFFF)

/*MSC设备的FATFS使用，DISK_BLOCK_SIZE = 1页FLASH大小*/
#define DISK_BLOCK_SIZE     (512)
/*(FAT_AND_NEW_APP_FLASH_E - FAT_AND_NEW_APP_FLASH_S)/DISK_BLOCK_SIZE*/
#define DISK_BLOCK_NR       (256)

#define SECTION_ADDR(sec)   (FAT_AND_NEW_APP_FLASH_S + (DISK_BLOCK_SIZE * (sec)))

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

#ifdef __cplusplus
extern "C"
}
#endif /*__cplusplus*/
#endif /*__USB_MSC_BOOT_H__*/
