/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file for DEMO
 *
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date               Author          Notes
 *          2023-01-17         liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"
#include "stdio.h"
#include "string.h"
#include "md_utils.h"
#include "md_cmu.h"
#include "md_rmu.h"
#include "md_gpio.h"
#include "md_uart.h"
#include "md_csu.h"
#include "md_msc.h"
#include "md_crc.h"
#include "boot_conf.h"
#include "boot_fatfs.h"
#include "usb_config.h"

/* Exported Macros ----------------------------------------------------------- */
/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern uint32_t g_write_fatfs_time_ms;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
extern void usb_descriptor_init(void);
extern int usbd_read_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern int usbd_write_packet(uint8_t ep_addr, uint8_t *buffer, uint16_t len);
extern uint8_t es_iap_program_words(uint32_t addr, uint8_t *buf, uint32_t len, uint8_t en);

#endif /*__MAIN_H__*/
/******************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
