/*******************************************************************************
* Function Name  : do_pid_state
* Description    : PID in ASM, Error computed outside the routine
* Input          : a0 - Error: difference between reference and measured value
*                  a1 - PID_state: pointer to the PID state struct
*                       
* Output         : None
* Return         : PID output (command)
;*******************************************************************************/

.global do_pid_state
.type   do_pid_state, %function
do_pid_state:
/*
	a0 - [IN] Err | [OUT] Result
	a1 - PID_state (Kp Ki Kd g_prev_error Integral )
	t0 - Kp
	t1 - Ki
	t2 - Kd
	a2 - Intergral
	a3 - PrevErr
	a4 - Output temp
*/
  lh t0, (a1)		/* Load Kp */
  lh t1, 2(a1)		/* Load Ki */
  lh t2, 4(a1)		/* Load Kd */
  lh a3, 6(a1)		/* Load PrevErr */
  lw a2, 8(a1)		/* Load Integral */
  
  mul a4,t1,a0		/* Ki*error */
  add a2,a2,a4 		/* Integral += Ki*error  */
  
  mul a4,t0,a0		/* (Kp * Error) */
  add a4,a4,a2		/* Output = (Kp * Error) + Intergral  */
  
  sub a3,a0,a3		/* (Error - g_prev_error) */
  mul a3,t2,a3		/* Kd * (Error - g_prev_error) */
  add a4,a4,a3		/* Output += Kd * (Error - g_prev_error) */

  sh  a0,6(a1)		/* Write back g_prev_error */
  sw  a2,8(a1)		/* Write back Intergral  */
  
  mv a0,a4
  ret
  
/*******************************************************************************
* Function Name  : do_pid
* Description    : PID in ASM, Error computed outside the routine
* Input          : a0 - Error: difference between reference and measured value
*                  a1 - PID_state: pointer to the PID state struct
*                       
* Output         : None
* Return         : PID output (command)
*******************************************************************************/
.global do_pid_asm
.type   do_pid_asm, %function
.extern g_int_term
.extern g_prev_error
do_pid_asm:
/*
	a0 - [IN] Err | [OUT] Result
	a1 - PID_state (Kp Ki Kd Integral  g_prev_error)
	t0 - Kp
	t1 - Ki
	t2 - Kd
	a2 - Intergral
	a3 - PrevErr
	a4 - Output temp
*/
  lh t0, (a1)		/* Load Kp */
  lh t1, 2(a1)		/* Load Ki */
  lh t2, 4(a1)		/* Load Kd */
  la a1, g_int_term
  lw a2, (a1)		/* Load Integral */
  la a1, g_prev_error
  lw a3, (a1)		/* Load PrevErr */
  
  mul a4,t1,a0		/* (Ki*error) */
  add a2,a2,a4 		/* Integral += Ki*error  */
  
  mul a4,t0,a0		/* (Kp * Error) */
  add a4,a4,a2		/* Output = (Kp * Error) + Intergral  */
  
  sub a3,a0,a3		/* (Error - g_prev_error) */
  mul a3,t2,a3		/* Kd * (Error - g_prev_error) */
  add a4,a4,a3		/* Output += Kd * (Error - g_prev_error) */
  
  la a1, g_int_term
  sw a2, (a1)		/* Write back Integral */
  la a1, g_prev_error
  sw a0, (a1)		/* Write back PrevErr */
  mv a0,a4			/* move output */
  
  ret