/*******************************************************************************
* Function Name  : iirarma_stm32
* Description    : IIR order ARMA 16-bit filter
* Input          : - y: Output array .
*                  - x: Input array 
*                  - h2: AutoRegressive part Filter Coefficients
*                  - h1: Moving Average part Filter Coefficients
*                  - ny: the number of output samples
* Output         : None
* Return         : None
*******************************************************************************/
/* void iir_biquad_asm(void *y, void *x,  short *h2, short *h1, int ny) */
/*
y       a0
x       a1
h2      a2
h1      a3
ar_a    a5
ar_b    t0
ar_c    t1
ar_d    t2
val_ny  a4
*/
.global iir_arma
.type   iir_arma, %function
iir_arma:
		li t0,1
		beq a4, t0,done_for_now        /* if val_ny==1 go to done_for_now */

acc_five_data:
		lh  a5, 0(a2)
		lh  t0, 8(a1)
		lh  t1, 2(a2)
		lh  t2, 6(a1)

		addi a4, a4, -1   /*decrement val_ny*/
		mul t1, t2, t1
		mul a5,t0,a5
		add a5,a5,t1
		lh  t0, 2(a3)
		lh  t1, 6(a0)
		
		mul t0, t1,t0
		lh  t1, 4(a1)
		sub a5, a5, t0
		lh  t0, 4(a2)
		mul t0,t1,t0
		add a5,t0,a5
		
		lh  t0, 4(a3)
		lh  t1, 4(a0)
		mul t0, t1, t0
		lh  t1, 2(a1)
		sub a5, a5, t0
		lh  t0, 6(a2)
		mul t0,t1,t0
		add a5,t0,a5
		
		lh  t0, 6(a3)
		lh  t1, 2(a0)
		mul t0, t1, t0
		lh  t1, (a1)
		add a1,a1,2
		sub a5, a5, t0
		lh  t0, 8(a2)
		mul t0,t1,t0
		add a5,t0,a5
		
		lh  t0, 8(a3)
		lh  t1, 0(a0)
		mul t0, t1, t0
		sub a5, a5, t0
		srai a5, a5, 15
		
		sh  a5, 8(a0)
		add a0, a0, 2
		bne a4,zero,acc_five_data

done_for_now:
		ret
.end          

