/**********************************************************************************
 *
 * @file    reg_syscfg.h
 * @brief   SYSCFG Head File
 *
 * @date    07 July 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 July 2022    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __REG_SYSCFG_H__
#define __REG_SYSCFG_H__

/* Includes ------------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */

/****************** Bit definition for SYSCFG_PROT register ************************/

#define SYSCFG_PROT_KEY_POSS    1U
#define SYSCFG_PROT_KEY_POSE    31U
#define SYSCFG_PROT_KEY_MSK BITS(SYSCFG_PROT_KEY_POSS,SYSCFG_PROT_KEY_POSE)

#define SYSCFG_PROT_PROT_POS    0U
#define SYSCFG_PROT_PROT_MSK    BIT(SYSCFG_PROT_PROT_POS)

/****************** Bit definition for SYSCFG_BTADDR register ************************/

#define SYSCFG_BTADDR_BTADDR_POSS   0U
#define SYSCFG_BTADDR_BTADDR_POSE   17U
#define SYSCFG_BTADDR_BTADDR_MSK    BITS(SYSCFG_BTADDR_BTADDR_POSS,SYSCFG_BTADDR_BTADDR_POSE)

/****************** Bit definition for SYSCFG_TBKCFG register ************************/

#define SYSCFG_TBKCFG_CLUBKE_POS    2U
#define SYSCFG_TBKCFG_CLUBKE_MSK    BIT(SYSCFG_TBKCFG_CLUBKE_POS)

#define SYSCFG_TBKCFG_LVDBKE_POS    1U
#define SYSCFG_TBKCFG_LVDBKE_MSK    BIT(SYSCFG_TBKCFG_LVDBKE_POS)

#define SYSCFG_TBKCFG_CCSBKE_POS    0U
#define SYSCFG_TBKCFG_CCSBKE_MSK    BIT(SYSCFG_TBKCFG_CCSBKE_POS)

/****************** Bit definition for SYSCFG_PISIOCFG register ************************/

#define SYSCFG_PISIOCFG_IO15SEL_POSS    30U
#define SYSCFG_PISIOCFG_IO15SEL_POSE    31U
#define SYSCFG_PISIOCFG_IO15SEL_MSK BITS(SYSCFG_PISIOCFG_IO15SEL_POSS,SYSCFG_PISIOCFG_IO15SEL_POSE)

#define SYSCFG_PISIOCFG_IO14SEL_POSS    28U
#define SYSCFG_PISIOCFG_IO14SEL_POSE    29U
#define SYSCFG_PISIOCFG_IO14SEL_MSK BITS(SYSCFG_PISIOCFG_IO14SEL_POSS,SYSCFG_PISIOCFG_IO14SEL_POSE)

#define SYSCFG_PISIOCFG_IO13SEL_POSS    26U
#define SYSCFG_PISIOCFG_IO13SEL_POSE    27U
#define SYSCFG_PISIOCFG_IO13SEL_MSK BITS(SYSCFG_PISIOCFG_IO13SEL_POSS,SYSCFG_PISIOCFG_IO13SEL_POSE)

#define SYSCFG_PISIOCFG_IO12SEL_POSS    24U
#define SYSCFG_PISIOCFG_IO12SEL_POSE    25U
#define SYSCFG_PISIOCFG_IO12SEL_MSK BITS(SYSCFG_PISIOCFG_IO12SEL_POSS,SYSCFG_PISIOCFG_IO12SEL_POSE)

#define SYSCFG_PISIOCFG_IO11SEL_POSS    22U
#define SYSCFG_PISIOCFG_IO11SEL_POSE    23U
#define SYSCFG_PISIOCFG_IO11SEL_MSK BITS(SYSCFG_PISIOCFG_IO11SEL_POSS,SYSCFG_PISIOCFG_IO11SEL_POSE)

#define SYSCFG_PISIOCFG_IO10SEL_POSS    20U
#define SYSCFG_PISIOCFG_IO10SEL_POSE    21U
#define SYSCFG_PISIOCFG_IO10SEL_MSK BITS(SYSCFG_PISIOCFG_IO10SEL_POSS,SYSCFG_PISIOCFG_IO10SEL_POSE)

#define SYSCFG_PISIOCFG_IO9SEL_POSS 18U
#define SYSCFG_PISIOCFG_IO9SEL_POSE 19U
#define SYSCFG_PISIOCFG_IO9SEL_MSK  BITS(SYSCFG_PISIOCFG_IO9SEL_POSS,SYSCFG_PISIOCFG_IO9SEL_POSE)

#define SYSCFG_PISIOCFG_IO8SEL_POSS 16U
#define SYSCFG_PISIOCFG_IO8SEL_POSE 17U
#define SYSCFG_PISIOCFG_IO8SEL_MSK  BITS(SYSCFG_PISIOCFG_IO8SEL_POSS,SYSCFG_PISIOCFG_IO8SEL_POSE)

#define SYSCFG_PISIOCFG_IO7SEL_POSS 14U
#define SYSCFG_PISIOCFG_IO7SEL_POSE 15U
#define SYSCFG_PISIOCFG_IO7SEL_MSK  BITS(SYSCFG_PISIOCFG_IO7SEL_POSS,SYSCFG_PISIOCFG_IO7SEL_POSE)

#define SYSCFG_PISIOCFG_IO6SEL_POSS 12U
#define SYSCFG_PISIOCFG_IO6SEL_POSE 13U
#define SYSCFG_PISIOCFG_IO6SEL_MSK  BITS(SYSCFG_PISIOCFG_IO6SEL_POSS,SYSCFG_PISIOCFG_IO6SEL_POSE)

#define SYSCFG_PISIOCFG_IO5SEL_POSS 10U
#define SYSCFG_PISIOCFG_IO5SEL_POSE 11U
#define SYSCFG_PISIOCFG_IO5SEL_MSK  BITS(SYSCFG_PISIOCFG_IO5SEL_POSS,SYSCFG_PISIOCFG_IO5SEL_POSE)

#define SYSCFG_PISIOCFG_IO4SEL_POSS 8U
#define SYSCFG_PISIOCFG_IO4SEL_POSE 9U
#define SYSCFG_PISIOCFG_IO4SEL_MSK  BITS(SYSCFG_PISIOCFG_IO4SEL_POSS,SYSCFG_PISIOCFG_IO4SEL_POSE)

#define SYSCFG_PISIOCFG_IO3SEL_POSS 6U
#define SYSCFG_PISIOCFG_IO3SEL_POSE 7U
#define SYSCFG_PISIOCFG_IO3SEL_MSK  BITS(SYSCFG_PISIOCFG_IO3SEL_POSS,SYSCFG_PISIOCFG_IO3SEL_POSE)

#define SYSCFG_PISIOCFG_IO2SEL_POSS 4U
#define SYSCFG_PISIOCFG_IO2SEL_POSE 5U
#define SYSCFG_PISIOCFG_IO2SEL_MSK  BITS(SYSCFG_PISIOCFG_IO2SEL_POSS,SYSCFG_PISIOCFG_IO2SEL_POSE)

#define SYSCFG_PISIOCFG_IO1SEL_POSS 2U
#define SYSCFG_PISIOCFG_IO1SEL_POSE 3U
#define SYSCFG_PISIOCFG_IO1SEL_MSK  BITS(SYSCFG_PISIOCFG_IO1SEL_POSS,SYSCFG_PISIOCFG_IO1SEL_POSE)

#define SYSCFG_PISIOCFG_IO0SEL_POSS 0U
#define SYSCFG_PISIOCFG_IO0SEL_POSE 1U
#define SYSCFG_PISIOCFG_IO0SEL_MSK  BITS(SYSCFG_PISIOCFG_IO0SEL_POSS,SYSCFG_PISIOCFG_IO0SEL_POSE)

/* Exported Types ------------------------------------------------------------ */

typedef struct
{
    __IO uint32_t PROT;
    uint32_t RESERVED0 ;
    __IO uint32_t BTADDR;
    __IO uint32_t TBKCFG;
    __IO uint32_t PISIOCFG;
} SYSCFG_TypeDef;

#endif /* __REG_SYSCFG_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/