/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  uart.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/5
*描  述:    UART模块程序printf
*备  注:    适用于ES8H018x
            本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#include "uart.h"
#include "string.h"
#include <rtthread.h>

#ifdef RT_USING_CONSOLE

/**
  * @brief  UART send one character
  * @param  c: character want to send
  * @retval None.
  */
void uart_send_ch(char ch)
{
    FlagStatus Status = RESET;
    uint32_t Count = 0;
    
    UART_SendByte(UART3, (unsigned char) ch);

    do
    {
        Status = UART_GetFlagStatus(UART3, UART_FLAG_TXIDLE);
        Count++;
    }
    while ((Status == RESET) && (Count != 0x1CE2));

    UART_ClearITPendingBit(UART3, UART_Clr_TXIDLE);
}


/**
  * @brief  UART get one character
  * @param  c: character received (-1 if nothing received)
  * @retval None.
  */
int uart_get_ch()
{
    char ch=(char)-1;
    
    if (UART_GetFlagStatus(UART3, UART_FLAG_RB))
    {
        ch = UART_RecByte(UART3);
    }
    return ch;
}

/**
  * @brief  rt-thread read one char
  * @param  None.
  * @retval char read or -1 if no char
  */
char rt_hw_console_getchar(void)
{
    int ch = uart_get_ch();
    //if (ch==-1)
    //    rt_thread_mdelay(1);
    return ch;
}

/**
  * @brief  rt-thread console output to uart
  * @param  str : string to output
  * @retval None.
  */
void rt_hw_console_output(const char *str)
{
    rt_size_t i;
    char last=0;
    for (i=0;str[i]!='\0';i++)
    {
        char c=str[i];
        if (c=='\n'&&last!='\r')
        {
            /* 如果有必要，补充一个'\r' */
            uart_send_ch('\r');
        }
        uart_send_ch(c);
    }
}

/**
  * @brief  Initialize UART
  * @param  None.
  * @retval 0
  */
int init_console_uart()
{
    GPIO_InitStruType y;
    UART_InitStruType uart;
    memset(&y, 0, sizeof(y));
    memset(&uart, 0, sizeof(uart));

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_6;
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = GPIO_PUE_Input_Disable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_8, &y);                 //PA8---TxD

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_6;
    y.GPIO_Direction = GPIO_Dir_In;
    y.GPIO_PUEN = GPIO_PUE_Input_Enable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_7, &y);                 //PA7---RxD

    uart.UART_StopBits = UART_StopBits_1;          //停止位：1
    uart.UART_TxMode = UART_DataMode_8;            //发送数据格式：8位数据
    uart.UART_TxPolar = UART_Polar_Normal;         //发送端口极性：正常
    uart.UART_RxMode = UART_DataMode_8;            //接收数据格式：8位数据
    uart.UART_RxPolar = UART_Polar_Normal;         //接收端口极性：正常
    uart.UART_BaudRate = 115200;                     //波特率
    uart.UART_ClockSet = UART_Clock_1;             //时钟选择：Pclk
    UART_Init(UART3, &uart);

    //UART_TBIMConfig(UART3, UART_TRBIM_Byte);
    //UART_RBIMConfig(UART3, UART_TRBIM_Byte);
    //UART_ITConfig(UART3, UART_IT_RB, ENABLE);
    //NVIC_Init(NVIC_UART3_IRQn, NVIC_Priority_1, ENABLE);
    UART3_TxEnable();                               //UART3发送使能
    UART3_RxEnable();
    return 0;
}
INIT_BOARD_EXPORT(init_console_uart); 
#endif
