/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/5
*描  述:  coremark测试例程，printf打印，TX:PA8
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include <stdio.h>
#include "main.h"

volatile uint32_t g_systick=0;

__STATIC_INLINE uint32_t SYSTICK_IsActiveCounterFlag(void)
{
    return ((SysTick->CTRL & SysTick_CTRL_COUNTFLAG_Msk) == (SysTick_CTRL_COUNTFLAG_Msk));
}
uint64_t getCurrentMicros(void)
{
    /* Ensure COUNTFLAG is reset by reading SysTick control and status register */ 
    uint32_t m; 
    uint32_t tms; 
    __IO uint32_t u;
    
    SYSTICK_IsActiveCounterFlag();
    m= g_systick;
    tms= SysTick->LOAD + 1;
    u= tms - SysTick->VAL;
    if (SYSTICK_IsActiveCounterFlag())
    {
        m = g_systick;
        u = tms - SysTick->VAL;
    }
    return ((uint64_t)m)*100 + (u * 1000) / tms;
}
unsigned get_system_clock(void)
{
    extern uint32_t SystemCoreClock;
    return SystemCoreClock;
}
/*使用printf()函数需要调用微库：Use MicroLIB */
int fputc(int ch, FILE *f)
{
    FlagStatus Status = RESET;
    uint32_t Count = 0;
    
    /* Coremark的换行只使用'\n'，在这里添加一个'\r'，确保输出信息正确换行 */
    /* 正常情况下，请使用lib_printf.c */
    if (ch=='\n')
    {
        UART_SendByte(UART3, (unsigned char) '\r');
        do
        {
            Status = UART_GetFlagStatus(UART3, UART_FLAG_TXIDLE);
            Count++;
        }
        while ((Status == RESET) && (Count != 0x1CE2));
        UART_ClearITPendingBit(UART3, UART_Clr_TXIDLE);
    }
    
    UART_SendByte(UART3, (unsigned char) ch);

    do
    {
        Status = UART_GetFlagStatus(UART3, UART_FLAG_TXIDLE);
        Count++;
    }
    while ((Status == RESET) && (Count != 0x1CE2));

    UART_ClearITPendingBit(UART3, UART_Clr_TXIDLE);

    if (Count == 0x1CE2)
        return (EOF);
    return (ch);
}
int benchmark_coremark_main(void);
int main(void)
{
    SystemHRCSelect(SCU_HRC_48M);       //HRC
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟
    
    SCU_RegUnLock();
    SCU->FLASHWAIT.ACCT=1;              //FLASH等待时间1个周期
    SCU_RegLock();
    SysTickInit();
    UARTInit();                         //UART初始化(115200,8,NO,1)
    
    SysTick_Enable();
    printf("Startup @%d,FLASH_WAIT=%d\r\n",get_system_clock(),SCU->FLASHWAIT.ACCT);
    benchmark_coremark_main();
    while (1)
    {
    }
}

