/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2022/1/28
*描  述:  FreeRTOS例程，printf打印，TX:PA8
          可调用标准库使用，需要以下三个步骤
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、 #define __PRINTF_USE_UART3__
          2、IAR的Library选择Full
*备  注:  适用于ES8H018x芯片
          本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#include <stdio.h>
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <event_groups.h>
#include <stream_buffer.h>
#include <semphr.h>
#include "main.h"

/* 邮件数据结构定义 */
typedef struct my_mail
{
    uint32_t a;
    uint32_t b;
    uint8_t c;
} my_mail_t;

/*任务句柄*/
static TaskHandle_t g_task_app_handle = NULL;
static TaskHandle_t g_task_1_handle = NULL;
static TaskHandle_t g_task_2_handle = NULL;
static QueueHandle_t g_queue_test = NULL;

/* 任务 */
static void task_app(void *arg);
static void task_1(void *arg);
static void task_2(void *arg);

/* 测试数据 */
static volatile uint32_t s_producer_err = 0, s_consumer_err = 0;

int main(void)
{
    int retval;
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    UARTInit();                         //UART初始化(115200,8,NO,1)
    printf("Startup\r\n");

    retval = xTaskCreate(task_app, "AppTaskCreate", 128, NULL, 1, &g_task_app_handle);

    /* Start task schedule*/
    if (pdPASS == retval)
        vTaskStartScheduler();
    else
        return -1;

    /* Should nerver run to here */
    while (1)
    {
    }
}

static void task_app(void *arg)
{
    BaseType_t retval = pdPASS;

    taskENTER_CRITICAL();

    /* Create Queue length = 5, item_size = sizeof(my_mail_t) */
    g_queue_test = xQueueCreate(5, sizeof(my_mail_t));

    if (g_queue_test != NULL)
        printf("Create Test_Queue OK\r\n");

    /* Create task 1 */
    retval = xTaskCreate(task_1, "Task_1", 128, NULL, 2, &g_task_1_handle);

    if (pdPASS == retval)
        printf("Task 1 Created\r\n");

    /* Create task 2 */
    retval = xTaskCreate(task_2, "Task_2", 128, NULL, 3, &g_task_2_handle);

    if (pdPASS == retval)
        printf("Task 2 Created\r\n");

    /* Delete self */
    vTaskDelete(g_task_app_handle);

    taskEXIT_CRITICAL();
}

static void task_1(void *arg)
{
    my_mail_t msg;
    msg.a = 0;
    msg.b = 0;
    msg.c = 0;

    while (1)
    {
        /* Send message to queue */
        if (xQueueSend(g_queue_test, &msg, 3000) != pdTRUE)
        {
            /* Error */
            ++s_producer_err;
            printf("Send error count:%d\r\n", s_producer_err);
        }
        else
        {
            /* Update producer count */
            msg.a += 1;
            msg.b += 2;
            msg.c += 3;
            printf("Send    :a=%u,b=%u,c=%u\r\n", msg.a, msg.b, msg.c);
            vTaskDelay(1000);
        }
    }
}

static void task_2(void *arg)
{
    uint32_t val_a = 0U, val_b = 0U;
    uint8_t val_c = 0U;
    my_mail_t msg;

    while (1)
    {
        /* Receive message from queue */
        if (xQueueReceive(g_queue_test, &msg, 1000) == pdTRUE)
        {
            /* Check if value received data correct */
            if (msg.a == val_a && msg.b == val_b && msg.c == val_c)
            {
                /* Print receive count */
                printf("Received:a=%u,b=%u,c=%u\r\n", msg.a, msg.b, msg.c);

                /* Update producer count */
                val_a += 1;
                val_b += 2;
                val_c += 3;
            }
            else
            {
                /* Error */
                ++s_consumer_err;
                printf("RecvError:a=%u,b=%u,c=%u\r\n", msg.a, msg.b, msg.c);
            }
        }
        else
        {
            printf("Recv nothing!\r\n");
        }
    }
}
