/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *************************************************************************/
#include "ES8H018x.h"
#include "macro.h"
#include "typedef.h"
#include "string.h"
#include "lib_flashiap.h"

/***************************************************************
函数名：get_cusum32
描  述: 获取32bit累加和
输入值：起始地址，字节长度
输出值：无
返回值：32bit累加和结果
***************************************************************/
uint32_t  get_cusum32(uint32_t *data_ptr, uint32_t len)
{
    uint32_t  i, buf32;

    if ((((uint32_t)data_ptr) % 4 != 0) || (len % 4 != 0))
    {
        return 0;
    }

    buf32 = 0;

    for (i = 0; i < len; i += 4)
    {
        buf32 += *(data_ptr++);
    }

    return buf32;
}

/***************************************************************
函数名：check_empty
描  述:
输入值：起始地址，字节长度
输出值：无
返回值：32bit累加和结果
***************************************************************/
uint8_t check_empty(uint32_t *data_ptr, uint32_t len)
{
    uint32_t  i;

    if ((((uint32_t)data_ptr) % 4 != 0) || (len % 4 != 0))
    {
        return ERROR;
    }

    for (i = 0; i < len; i += 4)
    {
        if (*(data_ptr++) != 0xFFFFFFFF)
        {
            break;
        }
    }

    if (i != len)
    {
        return ERROR;
    }
    else
    {
        return SUCCESS;
    }
}

/**
 * @brief  解锁FLASH
 * @param  None
 * @retval None
 */
void IAP_FLASH_Unlock(void)
{
    IAP->FLASHKEY.Word = 0x8ACE0246;
    IAP->FLASHKEY.Word = 0x9BDF1357;
}

/**
 * @brief  解锁INFO
 * @param  None
 * @retval None
 */
void IAP_INFO_Unlock(void)
{
    IAP->INFOKEY.Word = 0x7153BFD9;
    IAP->INFOKEY.Word = 0x0642CEA8;
}

/**
 * @brief  锁定FLASH
 * @param  None
 * @retval None
 */
void IAP_FLASH_Lock(void)
{
    IAP->FLASHKEY.Word = 0x0;
}

/**
 * @brief  锁定FINFO
 * @param  None
 * @retval None
 */
void IAP_INFO_Lock(void)
{
    IAP->INFOKEY.Word = 0x0;
}

