﻿/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/15
*描  述:  APP_Systick演示程序
          GPIO：PA12

*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "ES8H018x.h"

uint32_t count;
/***************************************************************
函数名：systick_init
描  述: Systick初始化
输入值：无
输出值：无
返回值：无
***************************************************************/
void systick_init(void)
{
    SysTick->CTRL = 0x07;
    SysTick->LOAD = 16000;  //系统时钟16M，1ms产生一次中断
    SysTick->VAL = 0;
}

/***************************************************************
函数名：gpio_init
描  述: GPIO初始化
输入值：无
输出值：无
返回值：无
***************************************************************/
void gpio_init(void)
{
    SCU->PROT.Word = 0x55AA6996;
    SCU->PCLKEN0.GPIO_EN = 1;

    GPIO->PADIR.DIR_12 = 0;
}

int SystemInit(void)
{

    return 0;
}
/***************************************************************
函数名：main
描  述: boot 主函数
输入值：无
输出值：无
返回值：无
***************************************************************/

int main(void)
{
    gpio_init();
    systick_init();

    GPIO->PADATA.DATA_12 = 0;

    while (1);
}

/***************************************************************
函数名：SysTick_Handler
描  述: SysTick中断服务程序
输入值：无
输出值：无
返回值：无
***************************************************************/
void SysTick_IRQHandler(void)
{
    count++;

    if (count > 200)
    {
        count = 0;
        GPIO->PADATABRR.Word = 1U << 12;
    }
}
