/*********************************************************

*文件名:  wdt.h
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/5
*描  述:  WDT函数文件
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "wdt.h"
#include "string.h"

/***************************************************************
 描  述：WDT初始化初始化
 输入值：无
 返回值：无
***************************************************************/
void WdtInit(void)
{
    IWDT_InitStruType x;
    IWDT_RegUnLock();
    memset(&x, 0, sizeof(x));

    x.WDT_Tms = 2000;           //喂狗周期2s
    x.WDT_IE = ENABLE;          //DISABLE;ENABLE
    x.WDT_Rst = ENABLE;
    x.WDT_Clock = WDT_CLOCK_WDT;  //WDT_CLOCK_WDT;

    /* 注意：当IWDT是通过配置字使能时，IWDT_Init对IWDT_CON寄存器配置无效，
             此时用户需要通过函数IWDT_SetReloadValue自行配置IWDT_LOAD装载寄存器的值，
             配置IWDT_LOAD前需要对IWDT解锁，配置完成后要对IWDT上锁。*/
    IWDT_Init(&x);
    IWDT_Enable();
    IWDT_RegLock();


}
