/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2023/04/03
*描  述:  UART 接收 start70us 演示主程序
          上电后等待串口接收，发送相同Byte，UART0  TX:PA19，RX:PA20  
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "main.h"
#include "string.h"

/***************************************************************
 函数名：void PINTx_Init(void)
 描  述：端口中断初始化函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void PINTx_Init(void)
{
    PINT_Config(PINT4, PINT_SEL2, PINT_Trig_Fall);
    PINT4_MaskDisable();
    PINT4_Enable();
    NVIC_Init(NVIC_PINT4_IRQn, NVIC_Priority_1, ENABLE);

    return;
}

int main(void)
{
    SystemHRCSelect(SCU_HRC_48M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    SysTickInit();
    UARTInit();                         //UART初始化(9600,8,NO,1)
		PINTx_Init();

     while (1);
}

