/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/11
*描  述:  UART演示主程序
          上电后MCU发送“Hello world!”给上位机，然后LD1开始闪烁等待上位机发送数据，并将接收到的数据再返回给上位机；
          测试时，若将RX接地，LD1始终保持闪烁，恢复RX时，收发数据正常，说明RX持续低电平不会误触发接收中断。
          RX - PA8
          TX - PA7
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

int main(void)
{
    uint8_t i;
    uint8_t buf[] = {"Hello world!\r\n"};    //发送数据缓存

    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    SysTickInit();
    LightInit();
    UARTInit();                         //UART初始化(115200,8,NO,1)

    for (i = 0; i < sizeof(buf); i++)
    {
        while (UART_GetFlagStatus(UART3, UART_FLAG_TB) == RESET);

        UART_SendByte(UART3, buf[i]);
    }

    while (1)
    {
        GPIOA_SetBit(GPIO_Pin_12);     //不进接收中断则LD1保持闪烁
        Delay1ms(200);
        GPIOA_ResetBit(GPIO_Pin_12);
        Delay1ms(200);
    }
}

