/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/5
*描  述:  UART模块例程，printf打印，TX:PA8
          可调用标准库使用，需要以下三个步骤
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、 #define __PRINTF_USE_UART3__
          2、IAR的Library选择Full
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include <stdio.h>
#include "main.h"

int main(void)
{
    uint8_t cnt = 245;
    unsigned char buf[] = {'E', 'a', 's', 't', 's', 'o', 'f', 't', '!', '\0'};

    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    SysTickInit();
    UARTInit();                         //UART初始化(9600,8,NO,1)

    while (1)
    {
        Delay1ms(1000);
        printf(" Hello world! \r\n");      //打印字符串
        Delay1ms(1000);
        printf(" cnt = %d \r\n", cnt);     //打印10进制数值
        Delay1ms(1000);
        printf(" %s \r\n", buf);           //打印字符
    }
}

