/*********************************************************

*文件名:  uart.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/11
*描  述:
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "uart.h"
#include "string.h"
/*********************************************************
函数名: void UARTInit(void)
描  述: UART初始化子程序
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void UARTInit(void)
{
	volatile uint8_t BaudConfigStatus;
	
    GPIO_InitStruType x;
    UART_InitStruType y;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_Func   = GPIO_Func_2;
    x.GPIO_OD     = GPIO_ODE_Output_Disable;
    x.GPIO_DS     = GPIO_DS_Output_Strong;
    x.GPIO_PUEN   = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN   = GPIO_PDE_Input_Disable;
    GPIO_Init(GPIOB, GPIO_Pin_1, &x);        //TXD - PB1

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func   = GPIO_Func_2;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_OD     = GPIO_ODE_Output_Disable;
    x.GPIO_DS     = GPIO_DS_Output_Strong;
    x.GPIO_PUEN   = GPIO_PUE_Input_Enable;
    x.GPIO_PDEN   = GPIO_PDE_Input_Disable;
    GPIO_Init(GPIOB, GPIO_Pin_0, &x);        //RXD - PB0

    y.UART_StopBits = UART_StopBits_1;       //停止位：1
    y.UART_TxMode   = UART_DataMode_8;       //发送数据格式：8位数据+奇校验
    y.UART_TxPolar  = UART_Polar_Normal;     //发送端口极性：正常
    y.UART_RxMode   = UART_DataMode_8;       //接收数据格式：8位数据
    y.UART_RxPolar  = UART_Polar_Normal;     //接收端口极性：正常
    y.UART_BaudRate = 1200;                  //波特率
    y.UART_ClockSet = UART_Clock_1;          //时钟选择：Pclk
	BaudConfigStatus = UART_Init(UART0, &y);    //若BaudConfigStatus=ERROR，表示UART波特率配置错误；若BaudConfigStatus=SUCCESS，表示UART波特率配置成功。


    GPIO_TX0Config(UART_TXPLV_Low, UART_TX0PS_BUZ, UART_TYPE_TXD0);
    BUZC_Frequence(38000, ENABLE);           //BUZ输出38kHz

    UART_TBIMConfig(UART0, UART_TRBIM_Byte);
    UART_RBIMConfig(UART0, UART_TRBIM_Byte);
    UART_ITConfig(UART0, UART_IT_RB, ENABLE);
    NVIC_Init(NVIC_UART0_IRQn, NVIC_Priority_1, ENABLE);

    UART0_TxEnable();
    UART0_RxEnable();
}
