/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/11
*描  述:  UART模块例程
          38kHz PWM调制，自发自收，发送数据0x55，接收到数据0x55后，点灯指示。
          TX/RX接红外对管RMT/RMR端测试，可使用HRSDK-GMB-01母板，TX：PB1，RX：PB0。
          注：波特率不要超过2400bps。
*备  注:   芯片
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

uint8_t g_recv_flag;
uint8_t g_rx_buf;

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    SysTickInit();
    LightInit();
    UARTInit();                         //UART初始化(1200,8,NO,1)

    g_recv_flag = 0;

    GPIOA_SetBit(GPIO_Pin_12);
    GPIOA_SetBit(GPIO_Pin_11);
    GPIOB_SetBit(GPIO_Pin_15);
    GPIOB_SetBit(GPIO_Pin_14);

    UART_SendByte(UART0, 0x55);

    while (1)
    {
        if (1 == g_recv_flag)
        {
            g_recv_flag = 0;
            g_rx_buf = 0;

            GPIOA_ResetBit(GPIO_Pin_12);  //接收到0x55后点灯指示
            Delay1ms(50);
        }
    }
}
