/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/10
*描  述:  定时器CAP演示主程序
          T32Nx对应引脚输入方波信号(信号发生器，100~200Hz时现象比较明显，定时器也不会溢出)，
                    T32Nx根据捕获状态和捕获次数发生一次中断，LD1指示灯翻转，
                    count0/count1记录捕获时的MAT0/MAT2值。
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**********************************************************/
#include "main.h"

int main(void)
{
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟
    DeviceClockAllEnable();             //打开所有外设时钟

    LightInit();
    T32N0CAPInit();                     //PA21,PA22输入捕获

    GPIOA_SetBit(GPIO_Pin_12);        //使用LD1指示捕获状态
    GPIOA_SetBit(GPIO_Pin_11);
    GPIOB_SetBit(GPIO_Pin_15);
    GPIOB_SetBit(GPIO_Pin_14);

    while (1);
}

