/*********************************************************

*文件名:  main.c
*作  者:  AT Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  SPI主机从机通信demo，本程序为主机程序，负责发起写和读。主机读取10字节数据，再发回10字节数据。
          默认使用中断方式接收数据，空闲时钟信号低电平，第二边沿采样。
          引脚连接A26-SCK(SPI_CLK),PA27-NSS(SPI_CS),PA25-SDI(SPI_DI),PA24-SDO(SPI_DO)。
          修改spi.c中的宏定义，当ISR定义为1时，采用中断方式收发；
          当ISR定义为0时，使用查询方式收发，该方式需适当降低波特率。
          使用ES-Bridge进行测试。
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include <string.h>
#include "main.h"
#include "systick.h"

int main(void)
{
    uint8_t w_buf[12] = {0x0};
    uint8_t r_buf[12] = {0x0};

    SystemHRCSelect(SCU_HRC_16M);   //HRC选择16MHz
    SystemClockConfig();            //配置时钟
    DeviceClockAllEnable();         //打开所有外设时钟
    SysTickInit();

    SPI_GPIO_Init();

    while (1)
    {
        SPIReadData(r_buf, 10);
        Delay1ms(2000);
        memcpy(w_buf, r_buf, 10);
        SPIWriteData(w_buf, 10);
        Delay1ms(2000);
    }
}
