/*************************************************************************
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 **************************************************************************/
#ifndef __IRQHANDLER_H__
#define __IRQHANDLER_H__

#include "main.h"
#include "systick.h"

extern uint8_t g_wbuf[64];
extern uint8_t g_rbuf[64];
extern uint8_t g_rbufamount;
extern uint8_t g_wbufamount;

extern void TimingDelay_Decrement(void);


volatile uint8_t rbufIndex;
volatile uint8_t wbufIndex;

/************中断函数声明***********/
void    NMI_IRQHandler(void);
void    HardFault_IRQHandler(void);
void    SVC_IRQHandler(void);
void    PendSV_IRQHandler(void);
void    SysTick_IRQHandler(void);


#endif

