/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2024/06/25
*描  述:  SPI Flash Interrupt Demo
          引脚连接:
          ------------------------
          SPI Flash:
          ------------------------
          NSS - PA27,
          SCK - PA26,
          MISO - PA25,
          MOSI - PA24
          ------------------------
          UART:
          ------------------------
          TXD - PA8
          RXD - PA7
          ------------------------
          本例程SPI主机方式与Flash芯片通信（中断方式），擦写读数据，通过UART打印读写结果
          使用ES-Bridge的UART接收打印数据。
          使用printf需以下步骤：
                    1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、keil #define __PRINTF_USE_UART3__
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include <string.h>
#include <stdio.h>
#include "main.h"

static char s_flash_txbuf[64] = "This is essemi mcu spi flash demo by IRQ.";     /*Length must be less than one page (256 bytes)*/
static char s_flash_rxbuf[64];

int main(void)
{
    uint32_t id;

    SystemHRCSelect(SCU_HRC_16M);   //HRC选择16MHz
    SystemClockConfig();            //配置时钟
    DeviceClockAllEnable();         //打开所有外设时钟
    SysTickInit();

    SPI_GPIO_Init();
    UARTInit();

    id = flash_read_id();
    printf("\r\nManufacturer ID is %02x & Device ID is %02x %02x\r\n", (uint8_t)(id >> 16), (uint8_t)(id >> 8), (uint8_t)id);

    printf("Now erase the sector containing address 0...\r\n");
    flash_sector_erase(0);

    flash_wait_unbusy();    /*Waiting for erasing*/
    printf("Erase OK!\r\n");

    printf("The date written to flash is -> %s\r\n", s_flash_txbuf);
    flash_write(0, s_flash_txbuf, strlen(s_flash_txbuf) + 1);

    flash_wait_unbusy();    /*Waiting for the written to complete*/
    printf("Write OK!\r\n");

    flash_read(0, s_flash_rxbuf, strlen(s_flash_txbuf) + 1);   /*Read write data*/
    printf("The data read from flash is  -> %s\r\n", s_flash_rxbuf);

    if (!memcmp(s_flash_txbuf, s_flash_rxbuf, strlen(s_flash_txbuf) + 1))   /*Data is written and read*/
        printf("Read OK!\r\n");
    else
        printf("Read ERROR!\r\n");

    while (1);
}
