/*********************************************************

*文件名:  flash.h
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/10
*描  述:
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#ifndef __FLASH_H__
#define __FLASH_H__

#include "lib_config.h"
#include "systick.h"

#define FLASH_WRITE_ENABLE  0x06
#define FLASH_ERASE         0x20
#define FLASH_PROGRAM       0x02
#define FLASH_READ          0x03
#define FLASH_ID            0x9F
#define FLASH_STATUS        0x05

/* 函数声明 */
void flash_sector_erase(uint32_t addr);
void flash_write(uint32_t addr, char *buf, uint8_t size);
void flash_read(uint32_t addr, char *buf, uint16_t size);
void flash_wait_unbusy(void);
uint32_t flash_read_id(void);

#endif
