/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/12
*描  述:  单电源供电sleep例程，程序功能如下：
              1.上电初始化后，LD1亮2s灭1s；
              2.进入主循环，LD1快速闪烁10次，然后进入深睡眠。
          唤醒源：
              PINT；
              KINT；
          接线：
              LD1：PA12；
              PINT：PA0，上升沿；
              KINT：PA3，上升沿。
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

int main(void)
{
    uint32_t i;

    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             //使能所有外设时钟
    SysTickInit();                      //系统滴答初始化

    /* 配置唤醒源PINT/KINT以及LED，LED初始化完成后亮2s灭1s */
    LightInit();
    LightOn();
    Delay1ms(2000);
    LightOff();
    Delay1ms(1000);

    KINTx_Init();
    PINTx_Init();

    while (1)
    {

        for (i = 0; i < 10; i++)
        {
            LightOn();
            Delay1ms(100);
            LightOff();
            Delay1ms(100);
        }

        /* 系统进入深睡 */
        deep_sleep();
    }
}
