/*********************************************************

*文件名:  sleep.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/12
*描  述:
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "sleep.h"
#include "key.h"
#include "systick.h"

/*********************************************************
函数名: void Sleep(uchar mode)
描  述: 进入待机模式子程序
输入值: mode - IDLE模式
输出值: 无
返回值: 无
**********************************************************/
void Sleep(uint8_t mode)
{
    uint32_t i;

    SCU_RegUnLock();
    SCU->WAKEUPTIME.Word = 0x00B28400;        /* LDO 1.4V，关闭HRC、PLL、XTAL和CLKFLT，其他按照手册推荐配置 */
    SCU_RegLock();

    __disable_irq(); //关闭IRQ总中断
    DeviceClockAllEnable();

    GPIO->PAINEB.Word = 0xFFFFFFFF; //输入关闭
    GPIO->PBINEB.Word = 0xFFFFFFFF;
    GPIO->PADIR.Word = 0x00000000;  //输出打开
    GPIO->PBDIR.Word = 0x00000000;
    GPIO->PADATA.Word = 0x00101000;  //PA12输出高关闭LED1 ，PA20输出高(PINT口上拉)
    GPIO->PBDATA.Word = 0x00000000;

    PINTInit();                             //初始化PINT

//    SCU->PCLKEN0.Word = 0x00000003;         //关闭所有外设时钟，scu无法关闭，同时保留GPIO时钟供外部中断唤醒
//    SCU->PCLKEN1.Word = 0x00000000;

    SCU_RegUnLock();
    SCU_LVDVS_4V0();    //LVD唤醒电压4.0V以上
    SCU_LVDIFS_Fall(); //LVDO下降沿检测
    SCU_LVDFLT_Enable(); //LVD滤波使能
    SCU_LVD_Enable(); //LVD使能
    SCU_RegLock();

    if (1 == mode)
        SCB_SystemLPConfig(SCB_LP_SleepDeep, ENABLE);   //配置为深度睡眠模式

    NVIC_EnableIRQ(CCM_LVD_PLK_IRQn);  //使能LVD唤醒源
    NVIC_EnableIRQ(IWDT_IRQn);  //使能WDT唤醒源

    while (1) //休眠主循环
    {

        NVIC->ICPR[0] = 0xFFFFFFFF; //清NVIC挂起标识
        __NOP();
        __NOP();
        __WFI();
        __NOP();
        __NOP();


        if (SCU_GetLVDFlagStatus(SCU_LVDFlag_IF) != RESET) //LVD唤醒
        {
            SCU_RegUnLock();
            SCU_LVDClearIFBit();
            SCU_RegLock();
            NVIC_SystemReset();   //复位唤醒
        }

        if (IWDT_GetFlagStatus() != RESET)
            IWDT_Clear();   //清狗

        if (PINT_GetITFlag(PINT_IT_PINT4) != RESET)  //唤醒
        {
            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            for (i = 0; i < 65350; i++);

            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            for (i = 0; i < 65350; i++);

            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            for (i = 0; i < 65350; i++);

            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            for (i = 0; i < 65350; i++);

            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            for (i = 0; i < 65350; i++);

            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            for (i = 0; i < 65350; i++);

            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            for (i = 0; i < 65350; i++);

            GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
            
            PINT_ClearITPendingBit(PINT_IT_PINT4);    // 清中断标志
        }
    }
}
