/*********************************************************

*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/12
*描  述:  sleep示例程序，单独使用子板进行试验(需要断开子板上电源指示灯的限流电阻)，
          当供电电压低于3.6V进行休眠程序，
          当供电电压高于4.0V退出休眠程序，PA12连续翻转
          休眠程序唤醒源如下：
          1.提供IWDT唤醒(需要配置字使能硬件看门狗)
          2.外部中断唤醒(PA20接0)后PA12连续翻转6次
          3.LVD唤醒系统软复位退出休眠函数
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "main.h"

uint8_t g_sleep_flag = 0;
int main(void)
{
    uint32_t i;
    GPIO_InitStruType x;

    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置系统时钟HRC
    DeviceClockAllEnable();             //使能所有外设时钟
    SysTickInit();                      //系统滴答初始化

    //以下开始检测LVD电压是否满足进入低功耗状态
    SCU_RegUnLock(); //scu写保护解锁
    SCU_LVDIFS_High(); //LVD高电平检测
    SCU_LVDVS_3V6();   //LVD休眠电压3.6V
    SCU_LVDFLT_Enable(); //LVD滤波使能
    SCU_LVD_Enable();   //LVD使能
    SCU_LVDIT_Enable(); //LVD中断使能
    SCU_RegLock();  //scu写保护上锁
    Delay100us(10); //延时1ms
    
    if (SCU_GetLVDFlagStatus(SCU_LVDFlag_Out) == SET) //LVD检测到电压低于3.6V
        Sleep(1); //进入休眠函数

    //以下开始进行主循环初始化
    SCU_RegUnLock();
    SCU_LVDIFS_Rise(); //LVD上升沿检测
    NVIC_Init(NVIC_CCM_LVD_PLK_IRQn, NVIC_Priority_0, ENABLE); //LVD中断设置，优先级设为最高
    SCU_RegLock();

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_OD = GPIO_ODE_Output_Disable;
    x.GPIO_DS = GPIO_DS_Output_Normal;
    x.GPIO_PDEN = GPIO_PDE_Input_Disable;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;

    GPIO_Init(GPIOA, GPIO_Pin_12, &x); //PA12配置为输出 
    GPIOA_SetBit(GPIO_Pin_12);         


    while (1)
    {
        GPIOA_ToggleBit(GPIO_Pin_12);  //PA12翻转
        IWDT_Clear();   //清狗

        for (i = 0; i < 165350; i++);

        if (g_sleep_flag == 1)  //LVD中断检测到VDD电压低于3.6V，则复位进入休眠函数
            NVIC_SystemReset();
    }
}
