/*********************************************************

*文件名:  sleep.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/12
*描  述:  休眠函数
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "sleep.h"

/***************************************************************
 函数名：void light_sleep(void)
 描  述：进入浅睡眠
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void light_sleep(void)
{
    SCB_SystemLPConfig(SCB_LP_SleepDeep, DISABLE);      /* 浅睡眠 */
    SCB_SystemLPConfig(SCB_LP_SleepOnExit, DISABLE);    /* 从ISR中断处理程序返回到线程模式时不进入休眠 */
    SCB_SystemLPConfig(SCB_LP_SEVOPend, ENABLE);        /* 中断挂起作为唤醒事件 */

    /* 清除所有挂起中断标志位 */
    __disable_irq();
    NVIC->ICPR[0] = NVIC->ICPR[0];
    __enable_irq();

    __NOP();
    __NOP();
    __WFI(); /* 休眠 */
    __NOP();
    __NOP();
}

/***************************************************************
 函数名：void deep_sleep(void)
 描  述：进入深度睡眠
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void deep_sleep(void)
{
    SCU_RegUnLock();
    SCU->WAKEUPTIME.Word = 0x00B28400;                  /* LDO 1.4V，关闭HRC、PLL、XTAL和CLKFLT，其他按照手册推荐配置*/
    SCB_SystemLPConfig(SCB_LP_SleepDeep, ENABLE);       /* 深度睡眠 */
    SCB_SystemLPConfig(SCB_LP_SleepOnExit, DISABLE);    /* 从ISR中断处理程序返回到线程模式时不进入休眠 */
    SCB_SystemLPConfig(SCB_LP_SEVOPend, ENABLE);        /* 中断挂起作为唤醒事件 */
    SCU_RegLock();

    /* 清除所有挂起中断标志位 */
    __disable_irq();
    NVIC->ICPR[0] = NVIC->ICPR[0];
    __enable_irq();

    __NOP();
    __NOP();
    __WFI(); /* 休眠 */
    __NOP();
    __NOP();
}
