/*********************************************************

*文件名:  gpio.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/12
*描  述:  外部端口中断配置程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "gpio.h"
#include "string.h"
/***************************************************************
 函数名：void PINTx_Init(void)
 描  述：端口中断初始化函数
 输入值：无
 输出值：无
 返回值：无
***************************************************************/
void PINTx_Init(void)
{
    GPIO_InitStruType x;
    memset(&x, 0, sizeof(x));

    x.GPIO_Signal = GPIO_Pin_Signal_Digital;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_PUEN = GPIO_PUE_Input_Disable;
    x.GPIO_PDEN = GPIO_PDE_Input_Enable;
    GPIO_Init(GPIOA, GPIO_Pin_0, &x);

    PINT_Config(PINT0, PINT_SEL0, PINT_Trig_Rise);
    PINT0_MaskDisable();
    PINT0_Enable();
    NVIC_Init(NVIC_PINT0_IRQn, NVIC_Priority_1, ENABLE);

    return;
}

