/*********************************************************

*文件名:  timer.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2021/11/4
*描  述:  T16N模块程序
*备  注:
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
**********************************************************/
#include "timer.h"
#include "string.h"
/*********************************************************
函数名: void PWM_Init(void)
描  述: pwm初始化
输入值: 无
输出值: 无
返回值: 无
**********************************************************/
void T16Nx_Init(void)
{
    TIM_BaseInitStruType x;
    GPIO_InitStruType y;
    T16Nx_PWMInitStruType z;
    memset(&x, 0, sizeof(x));
    memset(&y, 0, sizeof(y));
    memset(&z, 0, sizeof(z));
    x.TIM_ClkS = TIM_ClkS_PCLK;                         //选择时钟：Pclk
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_PWM ;                         //设为PWM模式
    T16Nx_BaseInit(T16N2, &x);

    T16N2_PwmOut0_Enable();                             //使能端口输出0
    T16Nx_MAT0Out0Config(T16N2, TIM_Out_High);          //匹配0：输出高
    T16Nx_MAT1Out0Config(T16N2, TIM_Out_Low);           //匹配1：输出低

    z.T16Nx_MOE0 = ENABLE;
    z.T16Nx_MOE1 = ENABLE;
    z.T16Nx_POL0 = POSITIVE;
    z.T16Nx_POL1 = POSITIVE;
    T16Nx_PWMOutConfig(T16N2, &z);                      //配置输出

    T16Nx_SetPREMAT(T16N2, 16);                         //预分频
    T16Nx_SetCNT(T16N2, 0);
    T16Nx_SetMAT0(T16N2, 250);                          //控制占空比，中心对齐
    T16Nx_SetMAT1(T16N2, 1750);                         //控制占空比，中心对齐
    T16Nx_SetTOP(T16N2, 2000);                          //控制周期

    NVIC_Init(NVIC_T16N2_IRQn, NVIC_Priority_1, DISABLE);

    T16Nx_MAT0ITConfig(T16N2, TIM_Go_Int);              //匹配0：继续计数
    T16Nx_MAT1ITConfig(T16N2, TIM_Go_Int);              //匹配1：继续计数

    T16Nx_ITConfig(T16N2, TIM_IT_MAT0, DISABLE);        //可选择是否使能中断
    T16Nx_ITConfig(T16N2, TIM_IT_MAT1, DISABLE);

    y.GPIO_Signal = GPIO_Pin_Signal_Digital;
    y.GPIO_Func = GPIO_Func_1;
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = GPIO_PUE_Input_Disable;
    y.GPIO_PDEN = GPIO_PDE_Input_Disable;
    y.GPIO_OD = GPIO_ODE_Output_Disable;
    y.GPIO_DS = GPIO_DS_Output_Normal;
    GPIO_Init(GPIOA, GPIO_Pin_10, &y);                   //PA10

    T16N2_Enable();
}
